/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.api;

import com.docusign.esign.client.ApiClient;
import com.docusign.esign.client.ApiException;
import com.docusign.esign.client.Configuration;
import com.docusign.esign.client.Pair;
import com.docusign.esign.model.PowerForm;
import com.docusign.esign.model.PowerFormSendersResponse;
import com.docusign.esign.model.PowerFormsFormDataResponse;
import com.docusign.esign.model.PowerFormsRequest;
import com.docusign.esign.model.PowerFormsResponse;
import com.sun.jersey.api.client.GenericType;
import java.util.ArrayList;
import java.util.HashMap;

public class PowerFormsApi {
    private ApiClient apiClient;

    public PowerFormsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public PowerFormsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return this.apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public PowerFormsResponse listPowerForms(String accountId) throws ApiException {
        return this.listPowerForms(accountId, null);
    }

    public PowerFormsResponse listPowerForms(String accountId, ListPowerFormsOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listPowerForms");
        }
        String path = "/v2/accounts/{accountId}/powerforms".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "from_date", options.fromDate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order", options.order));
            queryParams.addAll(this.apiClient.parameterToPairs("", "order_by", options.orderBy));
            queryParams.addAll(this.apiClient.parameterToPairs("", "to_date", options.toDate));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PowerFormsResponse> returnType = new GenericType<PowerFormsResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PowerForm createPowerForm(String accountId, PowerForm powerForm) throws ApiException {
        PowerForm postBody = powerForm;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling createPowerForm");
        }
        String path = "/v2/accounts/{accountId}/powerforms".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PowerForm> returnType = new GenericType<PowerForm>(){};
        return this.apiClient.invokeAPI(path, "POST", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PowerFormsResponse deletePowerForms(String accountId, PowerFormsRequest powerFormsRequest) throws ApiException {
        PowerFormsRequest postBody = powerFormsRequest;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deletePowerForms");
        }
        String path = "/v2/accounts/{accountId}/powerforms".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PowerFormsResponse> returnType = new GenericType<PowerFormsResponse>(){};
        return this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PowerFormSendersResponse listPowerFormSenders(String accountId) throws ApiException {
        return this.listPowerFormSenders(accountId, null);
    }

    public PowerFormSendersResponse listPowerFormSenders(String accountId, ListPowerFormSendersOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling listPowerFormSenders");
        }
        String path = "/v2/accounts/{accountId}/powerforms/senders".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "start_position", options.startPosition));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PowerFormSendersResponse> returnType = new GenericType<PowerFormSendersResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PowerForm getPowerForm(String accountId, String powerFormId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPowerForm");
        }
        if (powerFormId == null) {
            throw new ApiException(400, "Missing the required parameter 'powerFormId' when calling getPowerForm");
        }
        String path = "/v2/accounts/{accountId}/powerforms/{powerFormId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{powerFormId\\}", this.apiClient.escapeString(powerFormId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PowerForm> returnType = new GenericType<PowerForm>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public PowerForm updatePowerForm(String accountId, String powerFormId, PowerForm powerForm) throws ApiException {
        PowerForm postBody = powerForm;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling updatePowerForm");
        }
        if (powerFormId == null) {
            throw new ApiException(400, "Missing the required parameter 'powerFormId' when calling updatePowerForm");
        }
        String path = "/v2/accounts/{accountId}/powerforms/{powerFormId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{powerFormId\\}", this.apiClient.escapeString(powerFormId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PowerForm> returnType = new GenericType<PowerForm>(){};
        return this.apiClient.invokeAPI(path, "PUT", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public void deletePowerForm(String accountId, String powerFormId) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling deletePowerForm");
        }
        if (powerFormId == null) {
            throw new ApiException(400, "Missing the required parameter 'powerFormId' when calling deletePowerForm");
        }
        String path = "/v2/accounts/{accountId}/powerforms/{powerFormId}".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{powerFormId\\}", this.apiClient.escapeString(powerFormId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        this.apiClient.invokeAPI(path, "DELETE", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, null);
    }

    public PowerFormsFormDataResponse getPowerFormData(String accountId, String powerFormId) throws ApiException {
        return this.getPowerFormData(accountId, powerFormId, null);
    }

    public PowerFormsFormDataResponse getPowerFormData(String accountId, String powerFormId, GetPowerFormDataOptions options) throws ApiException {
        Object postBody = null;
        if (accountId == null) {
            throw new ApiException(400, "Missing the required parameter 'accountId' when calling getPowerFormData");
        }
        if (powerFormId == null) {
            throw new ApiException(400, "Missing the required parameter 'powerFormId' when calling getPowerFormData");
        }
        String path = "/v2/accounts/{accountId}/powerforms/{powerFormId}/form_data".replaceAll("\\{format\\}", "json").replaceAll("\\{accountId\\}", this.apiClient.escapeString(accountId.toString())).replaceAll("\\{powerFormId\\}", this.apiClient.escapeString(powerFormId.toString()));
        ArrayList<Pair> queryParams = new ArrayList<Pair>();
        HashMap<String, String> headerParams = new HashMap<String, String>();
        HashMap<String, Object> formParams = new HashMap<String, Object>();
        if (options != null) {
            queryParams.addAll(this.apiClient.parameterToPairs("", "from_date", options.fromDate));
            queryParams.addAll(this.apiClient.parameterToPairs("", "to_date", options.toDate));
        }
        String[] accepts = new String[]{"application/json"};
        String accept = this.apiClient.selectHeaderAccept(accepts);
        String[] contentTypes = new String[]{};
        String contentType = this.apiClient.selectHeaderContentType(contentTypes);
        String[] authNames = new String[]{"docusignAccessCode"};
        GenericType<PowerFormsFormDataResponse> returnType = new GenericType<PowerFormsFormDataResponse>(){};
        return this.apiClient.invokeAPI(path, "GET", queryParams, postBody, headerParams, formParams, accept, contentType, authNames, returnType);
    }

    public class GetPowerFormDataOptions {
        private String fromDate = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }

    public class ListPowerFormSendersOptions {
        private String startPosition = null;

        public void setStartPosition(String startPosition) {
            this.startPosition = startPosition;
        }

        public String getStartPosition() {
            return this.startPosition;
        }
    }

    public class ListPowerFormsOptions {
        private String fromDate = null;
        private String order = null;
        private String orderBy = null;
        private String toDate = null;

        public void setFromDate(String fromDate) {
            this.fromDate = fromDate;
        }

        public String getFromDate() {
            return this.fromDate;
        }

        public void setOrder(String order) {
            this.order = order;
        }

        public String getOrder() {
            return this.order;
        }

        public void setOrderBy(String orderBy) {
            this.orderBy = orderBy;
        }

        public String getOrderBy() {
            return this.orderBy;
        }

        public void setToDate(String toDate) {
            this.toDate = toDate;
        }

        public String getToDate() {
            return this.toDate;
        }
    }
}

