/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AddOn;
import com.docusign.esign.model.FeatureSet;
import com.docusign.esign.model.SeatDiscount;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Contains information about an account billing plan.")
public class AccountBillingPlan {
    private List<AddOn> addOns = new ArrayList<AddOn>();
    private String canCancelRenewal = null;
    private String canUpgrade = null;
    private String currencyCode = null;
    private String enableSupport = null;
    private String includedSeats = null;
    private String incrementalSeats = null;
    private String isDowngrade = null;
    private String otherDiscountPercent = null;
    private String paymentCycle = null;
    private String paymentMethod = null;
    private String perSeatPrice = null;
    private String planClassification = null;
    private List<FeatureSet> planFeatureSets = new ArrayList<FeatureSet>();
    private String planId = null;
    private String planName = null;
    private String renewalStatus = null;
    private List<SeatDiscount> seatDiscounts = new ArrayList<SeatDiscount>();
    private String supportIncidentFee = null;
    private String supportPlanFee = null;

    @ApiModelProperty(value="Reserved:")
    @JsonProperty(value="addOns")
    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public void setAddOns(List<AddOn> addOns) {
        this.addOns = addOns;
    }

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="canCancelRenewal")
    public String getCanCancelRenewal() {
        return this.canCancelRenewal;
    }

    public void setCanCancelRenewal(String canCancelRenewal) {
        this.canCancelRenewal = canCancelRenewal;
    }

    @ApiModelProperty(value="When set to **true**, specifies that you can upgrade the account through the API.")
    @JsonProperty(value="canUpgrade")
    public String getCanUpgrade() {
        return this.canUpgrade;
    }

    public void setCanUpgrade(String canUpgrade) {
        this.canUpgrade = canUpgrade;
    }

    @ApiModelProperty(value="Specifies the ISO currency code for the account.")
    @JsonProperty(value="currencyCode")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @ApiModelProperty(value="When set to **true**, then customer support is provided as part of the account plan.")
    @JsonProperty(value="enableSupport")
    public String getEnableSupport() {
        return this.enableSupport;
    }

    public void setEnableSupport(String enableSupport) {
        this.enableSupport = enableSupport;
    }

    @ApiModelProperty(value="The number of seats (users) included.")
    @JsonProperty(value="includedSeats")
    public String getIncludedSeats() {
        return this.includedSeats;
    }

    public void setIncludedSeats(String includedSeats) {
        this.includedSeats = includedSeats;
    }

    @ApiModelProperty(value="Reserved: TBD")
    @JsonProperty(value="incrementalSeats")
    public String getIncrementalSeats() {
        return this.incrementalSeats;
    }

    public void setIncrementalSeats(String incrementalSeats) {
        this.incrementalSeats = incrementalSeats;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="isDowngrade")
    public String getIsDowngrade() {
        return this.isDowngrade;
    }

    public void setIsDowngrade(String isDowngrade) {
        this.isDowngrade = isDowngrade;
    }

    @ApiModelProperty(value="Any other percentage discount for the plan.")
    @JsonProperty(value="otherDiscountPercent")
    public String getOtherDiscountPercent() {
        return this.otherDiscountPercent;
    }

    public void setOtherDiscountPercent(String otherDiscountPercent) {
        this.otherDiscountPercent = otherDiscountPercent;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="paymentCycle")
    public String getPaymentCycle() {
        return this.paymentCycle;
    }

    public void setPaymentCycle(String paymentCycle) {
        this.paymentCycle = paymentCycle;
    }

    @ApiModelProperty(value="The payment method used with the plan. The possible values are: CreditCard, PurchaseOrder, Premium, or Freemium.")
    @JsonProperty(value="paymentMethod")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="perSeatPrice")
    public String getPerSeatPrice() {
        return this.perSeatPrice;
    }

    public void setPerSeatPrice(String perSeatPrice) {
        this.perSeatPrice = perSeatPrice;
    }

    @ApiModelProperty(value="Identifies the type of plan. Examples include Business, Corporate, Enterprise, Free.")
    @JsonProperty(value="planClassification")
    public String getPlanClassification() {
        return this.planClassification;
    }

    public void setPlanClassification(String planClassification) {
        this.planClassification = planClassification;
    }

    @ApiModelProperty(value="A complex type that sets the feature sets for the account. It contains the following information (all string content):\n\n* currencyFeatureSetPrices - Contains the currencyCode and currencySymbol for the alternate currency values for envelopeFee, fixedFee, seatFee that are configured for this plan feature set.\n* envelopeFee - An incremental envelope cost for plans with envelope overages (when isEnabled=true).\n* featureSetId - A unique ID for the feature set.\n* fixedFee - A one-time fee associated with the plan (when isEnabled=true).\n* isActive - Specifies whether the feature set is actively set as part of the plan.\n* isEnabled - Specifies whether the feature set is actively enabled as part of the plan.\n* name - The name of the feature set.\n* seatFee - An incremental seat cost for seat-based plans (when isEnabled=true).")
    @JsonProperty(value="planFeatureSets")
    public List<FeatureSet> getPlanFeatureSets() {
        return this.planFeatureSets;
    }

    public void setPlanFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="planId")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    @ApiModelProperty(value="The name of the Billing Plan.")
    @JsonProperty(value="planName")
    public String getPlanName() {
        return this.planName;
    }

    public void setPlanName(String planName) {
        this.planName = planName;
    }

    @ApiModelProperty(value="The renewal status for the account. The acceptable values are:\n\n* auto: The account automatically renews.\n* queued_for_close: Account will be closed at the billingPeriodEndDate.\n* queued_for_downgrade: Account will be downgraded at the billingPeriodEndDate.")
    @JsonProperty(value="renewalStatus")
    public String getRenewalStatus() {
        return this.renewalStatus;
    }

    public void setRenewalStatus(String renewalStatus) {
        this.renewalStatus = renewalStatus;
    }

    @ApiModelProperty(value="A complex type that contains any seat discount information.\n\nValues are: BeginSeatCount, EndSeatCount, and SeatDiscountPercent.")
    @JsonProperty(value="seatDiscounts")
    public List<SeatDiscount> getSeatDiscounts() {
        return this.seatDiscounts;
    }

    public void setSeatDiscounts(List<SeatDiscount> seatDiscounts) {
        this.seatDiscounts = seatDiscounts;
    }

    @ApiModelProperty(value="The support incident fee charged for each support incident.")
    @JsonProperty(value="supportIncidentFee")
    public String getSupportIncidentFee() {
        return this.supportIncidentFee;
    }

    public void setSupportIncidentFee(String supportIncidentFee) {
        this.supportIncidentFee = supportIncidentFee;
    }

    @ApiModelProperty(value="The support plan fee charged for this plan.")
    @JsonProperty(value="supportPlanFee")
    public String getSupportPlanFee() {
        return this.supportPlanFee;
    }

    public void setSupportPlanFee(String supportPlanFee) {
        this.supportPlanFee = supportPlanFee;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountBillingPlan accountBillingPlan = (AccountBillingPlan)o;
        return Objects.equals(this.addOns, accountBillingPlan.addOns) && Objects.equals(this.canCancelRenewal, accountBillingPlan.canCancelRenewal) && Objects.equals(this.canUpgrade, accountBillingPlan.canUpgrade) && Objects.equals(this.currencyCode, accountBillingPlan.currencyCode) && Objects.equals(this.enableSupport, accountBillingPlan.enableSupport) && Objects.equals(this.includedSeats, accountBillingPlan.includedSeats) && Objects.equals(this.incrementalSeats, accountBillingPlan.incrementalSeats) && Objects.equals(this.isDowngrade, accountBillingPlan.isDowngrade) && Objects.equals(this.otherDiscountPercent, accountBillingPlan.otherDiscountPercent) && Objects.equals(this.paymentCycle, accountBillingPlan.paymentCycle) && Objects.equals(this.paymentMethod, accountBillingPlan.paymentMethod) && Objects.equals(this.perSeatPrice, accountBillingPlan.perSeatPrice) && Objects.equals(this.planClassification, accountBillingPlan.planClassification) && Objects.equals(this.planFeatureSets, accountBillingPlan.planFeatureSets) && Objects.equals(this.planId, accountBillingPlan.planId) && Objects.equals(this.planName, accountBillingPlan.planName) && Objects.equals(this.renewalStatus, accountBillingPlan.renewalStatus) && Objects.equals(this.seatDiscounts, accountBillingPlan.seatDiscounts) && Objects.equals(this.supportIncidentFee, accountBillingPlan.supportIncidentFee) && Objects.equals(this.supportPlanFee, accountBillingPlan.supportPlanFee);
    }

    public int hashCode() {
        return Objects.hash(this.addOns, this.canCancelRenewal, this.canUpgrade, this.currencyCode, this.enableSupport, this.includedSeats, this.incrementalSeats, this.isDowngrade, this.otherDiscountPercent, this.paymentCycle, this.paymentMethod, this.perSeatPrice, this.planClassification, this.planFeatureSets, this.planId, this.planName, this.renewalStatus, this.seatDiscounts, this.supportIncidentFee, this.supportPlanFee);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountBillingPlan {\n");
        if (this.addOns != null) {
            sb.append("    addOns: ").append(this.toIndentedString(this.addOns)).append("\n");
        }
        if (this.canCancelRenewal != null) {
            sb.append("    canCancelRenewal: ").append(this.toIndentedString(this.canCancelRenewal)).append("\n");
        }
        if (this.canUpgrade != null) {
            sb.append("    canUpgrade: ").append(this.toIndentedString(this.canUpgrade)).append("\n");
        }
        if (this.currencyCode != null) {
            sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        }
        if (this.enableSupport != null) {
            sb.append("    enableSupport: ").append(this.toIndentedString(this.enableSupport)).append("\n");
        }
        if (this.includedSeats != null) {
            sb.append("    includedSeats: ").append(this.toIndentedString(this.includedSeats)).append("\n");
        }
        if (this.incrementalSeats != null) {
            sb.append("    incrementalSeats: ").append(this.toIndentedString(this.incrementalSeats)).append("\n");
        }
        if (this.isDowngrade != null) {
            sb.append("    isDowngrade: ").append(this.toIndentedString(this.isDowngrade)).append("\n");
        }
        if (this.otherDiscountPercent != null) {
            sb.append("    otherDiscountPercent: ").append(this.toIndentedString(this.otherDiscountPercent)).append("\n");
        }
        if (this.paymentCycle != null) {
            sb.append("    paymentCycle: ").append(this.toIndentedString(this.paymentCycle)).append("\n");
        }
        if (this.paymentMethod != null) {
            sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        }
        if (this.perSeatPrice != null) {
            sb.append("    perSeatPrice: ").append(this.toIndentedString(this.perSeatPrice)).append("\n");
        }
        if (this.planClassification != null) {
            sb.append("    planClassification: ").append(this.toIndentedString(this.planClassification)).append("\n");
        }
        if (this.planFeatureSets != null) {
            sb.append("    planFeatureSets: ").append(this.toIndentedString(this.planFeatureSets)).append("\n");
        }
        if (this.planId != null) {
            sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        }
        if (this.planName != null) {
            sb.append("    planName: ").append(this.toIndentedString(this.planName)).append("\n");
        }
        if (this.renewalStatus != null) {
            sb.append("    renewalStatus: ").append(this.toIndentedString(this.renewalStatus)).append("\n");
        }
        if (this.seatDiscounts != null) {
            sb.append("    seatDiscounts: ").append(this.toIndentedString(this.seatDiscounts)).append("\n");
        }
        if (this.supportIncidentFee != null) {
            sb.append("    supportIncidentFee: ").append(this.toIndentedString(this.supportIncidentFee)).append("\n");
        }
        if (this.supportPlanFee != null) {
            sb.append("    supportPlanFee: ").append(this.toIndentedString(this.supportPlanFee)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

