/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AccountAddress;
import com.docusign.esign.model.AccountBillingPlan;
import com.docusign.esign.model.BillingPlan;
import com.docusign.esign.model.CreditCardInformation;
import com.docusign.esign.model.ReferralInformation;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines an account billing plan response object.")
public class AccountBillingPlanResponse {
    private AccountAddress billingAddress = null;
    private String billingAddressIsCreditCardAddress = null;
    private AccountBillingPlan billingPlan = null;
    private CreditCardInformation creditCardInformation = null;
    private ReferralInformation referralInformation = null;
    private List<BillingPlan> successorPlans = new ArrayList<BillingPlan>();

    @ApiModelProperty(value="")
    @JsonProperty(value="billingAddress")
    public AccountAddress getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(AccountAddress billingAddress) {
        this.billingAddress = billingAddress;
    }

    @ApiModelProperty(value="When set to **true**, the credit card address information is the same as that returned as the billing address. If false, then the billing address is considered a billing contact address, and the credit card address can be different.")
    @JsonProperty(value="billingAddressIsCreditCardAddress")
    public String getBillingAddressIsCreditCardAddress() {
        return this.billingAddressIsCreditCardAddress;
    }

    public void setBillingAddressIsCreditCardAddress(String billingAddressIsCreditCardAddress) {
        this.billingAddressIsCreditCardAddress = billingAddressIsCreditCardAddress;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="billingPlan")
    public AccountBillingPlan getBillingPlan() {
        return this.billingPlan;
    }

    public void setBillingPlan(AccountBillingPlan billingPlan) {
        this.billingPlan = billingPlan;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="creditCardInformation")
    public CreditCardInformation getCreditCardInformation() {
        return this.creditCardInformation;
    }

    public void setCreditCardInformation(CreditCardInformation creditCardInformation) {
        this.creditCardInformation = creditCardInformation;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="referralInformation")
    public ReferralInformation getReferralInformation() {
        return this.referralInformation;
    }

    public void setReferralInformation(ReferralInformation referralInformation) {
        this.referralInformation = referralInformation;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="successorPlans")
    public List<BillingPlan> getSuccessorPlans() {
        return this.successorPlans;
    }

    public void setSuccessorPlans(List<BillingPlan> successorPlans) {
        this.successorPlans = successorPlans;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountBillingPlanResponse accountBillingPlanResponse = (AccountBillingPlanResponse)o;
        return Objects.equals(this.billingAddress, accountBillingPlanResponse.billingAddress) && Objects.equals(this.billingAddressIsCreditCardAddress, accountBillingPlanResponse.billingAddressIsCreditCardAddress) && Objects.equals(this.billingPlan, accountBillingPlanResponse.billingPlan) && Objects.equals(this.creditCardInformation, accountBillingPlanResponse.creditCardInformation) && Objects.equals(this.referralInformation, accountBillingPlanResponse.referralInformation) && Objects.equals(this.successorPlans, accountBillingPlanResponse.successorPlans);
    }

    public int hashCode() {
        return Objects.hash(this.billingAddress, this.billingAddressIsCreditCardAddress, this.billingPlan, this.creditCardInformation, this.referralInformation, this.successorPlans);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountBillingPlanResponse {\n");
        if (this.billingAddress != null) {
            sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        }
        if (this.billingAddressIsCreditCardAddress != null) {
            sb.append("    billingAddressIsCreditCardAddress: ").append(this.toIndentedString(this.billingAddressIsCreditCardAddress)).append("\n");
        }
        if (this.billingPlan != null) {
            sb.append("    billingPlan: ").append(this.toIndentedString(this.billingPlan)).append("\n");
        }
        if (this.creditCardInformation != null) {
            sb.append("    creditCardInformation: ").append(this.toIndentedString(this.creditCardInformation)).append("\n");
        }
        if (this.referralInformation != null) {
            sb.append("    referralInformation: ").append(this.toIndentedString(this.referralInformation)).append("\n");
        }
        if (this.successorPlans != null) {
            sb.append("    successorPlans: ").append(this.toIndentedString(this.successorPlans)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

