/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains address information.")
public class AddressInformation {
    private String city = null;
    private String country = null;
    private String fax = null;
    private String phone = null;
    private String state = null;
    private String street1 = null;
    private String street2 = null;
    private String zip = null;

    @ApiModelProperty(value="The city associated with the address.")
    @JsonProperty(value="city")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    @ApiModelProperty(value="Specifies the country associated with the address.")
    @JsonProperty(value="country")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    @ApiModelProperty(value="A Fax number associated with the address if one is available.")
    @JsonProperty(value="fax")
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    @ApiModelProperty(value="A phone number associated with the address.")
    @JsonProperty(value="phone")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    @ApiModelProperty(value="The state or province associated with the address.")
    @JsonProperty(value="state")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    @ApiModelProperty(value="The first line of the address.")
    @JsonProperty(value="street1")
    public String getStreet1() {
        return this.street1;
    }

    public void setStreet1(String street1) {
        this.street1 = street1;
    }

    @ApiModelProperty(value="The second line of the address (optional).")
    @JsonProperty(value="street2")
    public String getStreet2() {
        return this.street2;
    }

    public void setStreet2(String street2) {
        this.street2 = street2;
    }

    @ApiModelProperty(value="The zip or postal code associated with the address.")
    @JsonProperty(value="zip")
    public String getZip() {
        return this.zip;
    }

    public void setZip(String zip) {
        this.zip = zip;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressInformation addressInformation = (AddressInformation)o;
        return Objects.equals(this.city, addressInformation.city) && Objects.equals(this.country, addressInformation.country) && Objects.equals(this.fax, addressInformation.fax) && Objects.equals(this.phone, addressInformation.phone) && Objects.equals(this.state, addressInformation.state) && Objects.equals(this.street1, addressInformation.street1) && Objects.equals(this.street2, addressInformation.street2) && Objects.equals(this.zip, addressInformation.zip);
    }

    public int hashCode() {
        return Objects.hash(this.city, this.country, this.fax, this.phone, this.state, this.street1, this.street2, this.zip);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressInformation {\n");
        if (this.city != null) {
            sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        }
        if (this.country != null) {
            sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        }
        if (this.fax != null) {
            sb.append("    fax: ").append(this.toIndentedString(this.fax)).append("\n");
        }
        if (this.phone != null) {
            sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        }
        if (this.state != null) {
            sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        }
        if (this.street1 != null) {
            sb.append("    street1: ").append(this.toIndentedString(this.street1)).append("\n");
        }
        if (this.street2 != null) {
            sb.append("    street2: ").append(this.toIndentedString(this.street2)).append("\n");
        }
        if (this.zip != null) {
            sb.append("    zip: ").append(this.toIndentedString(this.zip)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

