/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class ConnectCustomConfiguration {
    private String allowEnvelopePublish = null;
    private String allUsers = null;
    private String configurationType = null;
    private String connectId = null;
    private String enableLog = null;
    private String envelopeEvents = null;
    private String includeCertificateOfCompletion = null;
    private String includeCertSoapHeader = null;
    private String includeDocumentFields = null;
    private String includeDocuments = null;
    private String includeEnvelopeVoidReason = null;
    private String includeSenderAccountasCustomField = null;
    private String includeTimeZoneInformation = null;
    private String name = null;
    private String recipientEvents = null;
    private String requiresAcknowledgement = null;
    private String signMessageWithX509Certificate = null;
    private String soapNamespace = null;
    private String urlToPublishTo = null;
    private String userIds = null;
    private String useSoapInterface = null;

    @ApiModelProperty(value="When set to **true**, data is sent to the urlToPublishTo web address. This option can be set to false to stop sending data while maintaining the Connect configuration information.")
    @JsonProperty(value="allowEnvelopePublish")
    public String getAllowEnvelopePublish() {
        return this.allowEnvelopePublish;
    }

    public void setAllowEnvelopePublish(String allowEnvelopePublish) {
        this.allowEnvelopePublish = allowEnvelopePublish;
    }

    @ApiModelProperty(value="When set to **true**, the tracked envelope and recipient events for all users, including users that are added a later time, are sent through Connect.")
    @JsonProperty(value="allUsers")
    public String getAllUsers() {
        return this.allUsers;
    }

    public void setAllUsers(String allUsers) {
        this.allUsers = allUsers;
    }

    @ApiModelProperty(value="If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.")
    @JsonProperty(value="configurationType")
    public String getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(String configurationType) {
        this.configurationType = configurationType;
    }

    @ApiModelProperty(value="Specifies the DocuSign generated ID for the Connect configuration.")
    @JsonProperty(value="connectId")
    public String getConnectId() {
        return this.connectId;
    }

    public void setConnectId(String connectId) {
        this.connectId = connectId;
    }

    @ApiModelProperty(value="This turns Connect logging on or off. When set to **true**, logging is turned on.")
    @JsonProperty(value="enableLog")
    public String getEnableLog() {
        return this.enableLog;
    }

    public void setEnableLog(String enableLog) {
        this.enableLog = enableLog;
    }

    @ApiModelProperty(value="A comma separated list of \ufffdEnvelope\ufffd related events that are tracked through Connect. The possible event values are: Sent, Delivered, Completed, Declined, and Voided.")
    @JsonProperty(value="envelopeEvents")
    public String getEnvelopeEvents() {
        return this.envelopeEvents;
    }

    public void setEnvelopeEvents(String envelopeEvents) {
        this.envelopeEvents = envelopeEvents;
    }

    @ApiModelProperty(value="When set to **true**, the Connect Service includes the Certificate of Completion with completed envelopes.")
    @JsonProperty(value="includeCertificateOfCompletion")
    public String getIncludeCertificateOfCompletion() {
        return this.includeCertificateOfCompletion;
    }

    public void setIncludeCertificateOfCompletion(String includeCertificateOfCompletion) {
        this.includeCertificateOfCompletion = includeCertificateOfCompletion;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="includeCertSoapHeader")
    public String getIncludeCertSoapHeader() {
        return this.includeCertSoapHeader;
    }

    public void setIncludeCertSoapHeader(String includeCertSoapHeader) {
        this.includeCertSoapHeader = includeCertSoapHeader;
    }

    @ApiModelProperty(value="When set to **true**, the Document Fields associated with envelope documents are included in the data. Document Fields are optional custom name-value pairs added to documents using the API.")
    @JsonProperty(value="includeDocumentFields")
    public String getIncludeDocumentFields() {
        return this.includeDocumentFields;
    }

    public void setIncludeDocumentFields(String includeDocumentFields) {
        this.includeDocumentFields = includeDocumentFields;
    }

    @ApiModelProperty(value="When set to **true**, Connect will send the PDF document along with the update XML.")
    @JsonProperty(value="includeDocuments")
    public String getIncludeDocuments() {
        return this.includeDocuments;
    }

    public void setIncludeDocuments(String includeDocuments) {
        this.includeDocuments = includeDocuments;
    }

    @ApiModelProperty(value="When set to **true**, Connect will include the voidedReason for voided envelopes.")
    @JsonProperty(value="includeEnvelopeVoidReason")
    public String getIncludeEnvelopeVoidReason() {
        return this.includeEnvelopeVoidReason;
    }

    public void setIncludeEnvelopeVoidReason(String includeEnvelopeVoidReason) {
        this.includeEnvelopeVoidReason = includeEnvelopeVoidReason;
    }

    @ApiModelProperty(value="When set to **true**, Connect will include the sender account as Custom Field in the data.")
    @JsonProperty(value="includeSenderAccountasCustomField")
    public String getIncludeSenderAccountasCustomField() {
        return this.includeSenderAccountasCustomField;
    }

    public void setIncludeSenderAccountasCustomField(String includeSenderAccountasCustomField) {
        this.includeSenderAccountasCustomField = includeSenderAccountasCustomField;
    }

    @ApiModelProperty(value="When set to **true**, Connect will include the envelope time zone information.")
    @JsonProperty(value="includeTimeZoneInformation")
    public String getIncludeTimeZoneInformation() {
        return this.includeTimeZoneInformation;
    }

    public void setIncludeTimeZoneInformation(String includeTimeZoneInformation) {
        this.includeTimeZoneInformation = includeTimeZoneInformation;
    }

    @ApiModelProperty(value="The name of the Connect configuration. The name helps identify the configuration in the list.")
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @ApiModelProperty(value="A comma separated list of \ufffdRecipient\ufffd related events that are tracked through Connect. The possible event values are: Sent, Delivered, Completed, Declined, AuthenticationFailed, and AutoResponded.")
    @JsonProperty(value="recipientEvents")
    public String getRecipientEvents() {
        return this.recipientEvents;
    }

    public void setRecipientEvents(String recipientEvents) {
        this.recipientEvents = recipientEvents;
    }

    @ApiModelProperty(value="When set to **true**, and a publication message fails to be acknowledged, the message goes back into the queue and the system will retry delivery after a successful acknowledgement is received. If the delivery fails a second time, the message is not returned to the queue for sending until Connect receives a successful acknowledgement and it has been at least 24 hours since the previous retry. There is a maximum of ten retries Alternately, you can use Republish Connect Information to manually republish the envelope information.")
    @JsonProperty(value="requiresAcknowledgement")
    public String getRequiresAcknowledgement() {
        return this.requiresAcknowledgement;
    }

    public void setRequiresAcknowledgement(String requiresAcknowledgement) {
        this.requiresAcknowledgement = requiresAcknowledgement;
    }

    @ApiModelProperty(value="When set to **true**, Connect messages are signed with an X509 certificate. This provides support for 2-way SSL.")
    @JsonProperty(value="signMessageWithX509Certificate")
    public String getSignMessageWithX509Certificate() {
        return this.signMessageWithX509Certificate;
    }

    public void setSignMessageWithX509Certificate(String signMessageWithX509Certificate) {
        this.signMessageWithX509Certificate = signMessageWithX509Certificate;
    }

    @ApiModelProperty(value="The namespace of the SOAP interface.\n\nThe namespace value must be set if useSoapInterface is set to true.")
    @JsonProperty(value="soapNamespace")
    public String getSoapNamespace() {
        return this.soapNamespace;
    }

    public void setSoapNamespace(String soapNamespace) {
        this.soapNamespace = soapNamespace;
    }

    @ApiModelProperty(value="This is the web address and name of your listener or Retrieving Service endpoint. You need to include HTTPS:// in the web address.")
    @JsonProperty(value="urlToPublishTo")
    public String getUrlToPublishTo() {
        return this.urlToPublishTo;
    }

    public void setUrlToPublishTo(String urlToPublishTo) {
        this.urlToPublishTo = urlToPublishTo;
    }

    @ApiModelProperty(value="A comma separated list of userIds. This sets the users associated with the tracked envelope and recipient events. When one of the event occurs for a set user, the information is sent through Connect. \n\n###### Note: If allUsers is set to \ufffdfalse\ufffd then you must provide a list of user id\ufffds.")
    @JsonProperty(value="userIds")
    public String getUserIds() {
        return this.userIds;
    }

    public void setUserIds(String userIds) {
        this.userIds = userIds;
    }

    @ApiModelProperty(value="When set to **true**, indicates that the `urlToPublishTo` property contains a SOAP endpoint.")
    @JsonProperty(value="useSoapInterface")
    public String getUseSoapInterface() {
        return this.useSoapInterface;
    }

    public void setUseSoapInterface(String useSoapInterface) {
        this.useSoapInterface = useSoapInterface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectCustomConfiguration connectCustomConfiguration = (ConnectCustomConfiguration)o;
        return Objects.equals(this.allowEnvelopePublish, connectCustomConfiguration.allowEnvelopePublish) && Objects.equals(this.allUsers, connectCustomConfiguration.allUsers) && Objects.equals(this.configurationType, connectCustomConfiguration.configurationType) && Objects.equals(this.connectId, connectCustomConfiguration.connectId) && Objects.equals(this.enableLog, connectCustomConfiguration.enableLog) && Objects.equals(this.envelopeEvents, connectCustomConfiguration.envelopeEvents) && Objects.equals(this.includeCertificateOfCompletion, connectCustomConfiguration.includeCertificateOfCompletion) && Objects.equals(this.includeCertSoapHeader, connectCustomConfiguration.includeCertSoapHeader) && Objects.equals(this.includeDocumentFields, connectCustomConfiguration.includeDocumentFields) && Objects.equals(this.includeDocuments, connectCustomConfiguration.includeDocuments) && Objects.equals(this.includeEnvelopeVoidReason, connectCustomConfiguration.includeEnvelopeVoidReason) && Objects.equals(this.includeSenderAccountasCustomField, connectCustomConfiguration.includeSenderAccountasCustomField) && Objects.equals(this.includeTimeZoneInformation, connectCustomConfiguration.includeTimeZoneInformation) && Objects.equals(this.name, connectCustomConfiguration.name) && Objects.equals(this.recipientEvents, connectCustomConfiguration.recipientEvents) && Objects.equals(this.requiresAcknowledgement, connectCustomConfiguration.requiresAcknowledgement) && Objects.equals(this.signMessageWithX509Certificate, connectCustomConfiguration.signMessageWithX509Certificate) && Objects.equals(this.soapNamespace, connectCustomConfiguration.soapNamespace) && Objects.equals(this.urlToPublishTo, connectCustomConfiguration.urlToPublishTo) && Objects.equals(this.userIds, connectCustomConfiguration.userIds) && Objects.equals(this.useSoapInterface, connectCustomConfiguration.useSoapInterface);
    }

    public int hashCode() {
        return Objects.hash(this.allowEnvelopePublish, this.allUsers, this.configurationType, this.connectId, this.enableLog, this.envelopeEvents, this.includeCertificateOfCompletion, this.includeCertSoapHeader, this.includeDocumentFields, this.includeDocuments, this.includeEnvelopeVoidReason, this.includeSenderAccountasCustomField, this.includeTimeZoneInformation, this.name, this.recipientEvents, this.requiresAcknowledgement, this.signMessageWithX509Certificate, this.soapNamespace, this.urlToPublishTo, this.userIds, this.useSoapInterface);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ConnectCustomConfiguration {\n");
        if (this.allowEnvelopePublish != null) {
            sb.append("    allowEnvelopePublish: ").append(this.toIndentedString(this.allowEnvelopePublish)).append("\n");
        }
        if (this.allUsers != null) {
            sb.append("    allUsers: ").append(this.toIndentedString(this.allUsers)).append("\n");
        }
        if (this.configurationType != null) {
            sb.append("    configurationType: ").append(this.toIndentedString(this.configurationType)).append("\n");
        }
        if (this.connectId != null) {
            sb.append("    connectId: ").append(this.toIndentedString(this.connectId)).append("\n");
        }
        if (this.enableLog != null) {
            sb.append("    enableLog: ").append(this.toIndentedString(this.enableLog)).append("\n");
        }
        if (this.envelopeEvents != null) {
            sb.append("    envelopeEvents: ").append(this.toIndentedString(this.envelopeEvents)).append("\n");
        }
        if (this.includeCertificateOfCompletion != null) {
            sb.append("    includeCertificateOfCompletion: ").append(this.toIndentedString(this.includeCertificateOfCompletion)).append("\n");
        }
        if (this.includeCertSoapHeader != null) {
            sb.append("    includeCertSoapHeader: ").append(this.toIndentedString(this.includeCertSoapHeader)).append("\n");
        }
        if (this.includeDocumentFields != null) {
            sb.append("    includeDocumentFields: ").append(this.toIndentedString(this.includeDocumentFields)).append("\n");
        }
        if (this.includeDocuments != null) {
            sb.append("    includeDocuments: ").append(this.toIndentedString(this.includeDocuments)).append("\n");
        }
        if (this.includeEnvelopeVoidReason != null) {
            sb.append("    includeEnvelopeVoidReason: ").append(this.toIndentedString(this.includeEnvelopeVoidReason)).append("\n");
        }
        if (this.includeSenderAccountasCustomField != null) {
            sb.append("    includeSenderAccountasCustomField: ").append(this.toIndentedString(this.includeSenderAccountasCustomField)).append("\n");
        }
        if (this.includeTimeZoneInformation != null) {
            sb.append("    includeTimeZoneInformation: ").append(this.toIndentedString(this.includeTimeZoneInformation)).append("\n");
        }
        if (this.name != null) {
            sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        }
        if (this.recipientEvents != null) {
            sb.append("    recipientEvents: ").append(this.toIndentedString(this.recipientEvents)).append("\n");
        }
        if (this.requiresAcknowledgement != null) {
            sb.append("    requiresAcknowledgement: ").append(this.toIndentedString(this.requiresAcknowledgement)).append("\n");
        }
        if (this.signMessageWithX509Certificate != null) {
            sb.append("    signMessageWithX509Certificate: ").append(this.toIndentedString(this.signMessageWithX509Certificate)).append("\n");
        }
        if (this.soapNamespace != null) {
            sb.append("    soapNamespace: ").append(this.toIndentedString(this.soapNamespace)).append("\n");
        }
        if (this.urlToPublishTo != null) {
            sb.append("    urlToPublishTo: ").append(this.toIndentedString(this.urlToPublishTo)).append("\n");
        }
        if (this.userIds != null) {
            sb.append("    userIds: ").append(this.toIndentedString(this.userIds)).append("\n");
        }
        if (this.useSoapInterface != null) {
            sb.append("    useSoapInterface: ").append(this.toIndentedString(this.useSoapInterface)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

