/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.EnvelopeEvent;
import com.docusign.esign.model.RecipientEvent;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="This optional complex element allows a message to be sent a specified URL when the envelope or recipient changes status. It is similar to DocuSign Connect. For example, if an envelope changes from \"Sent\" to \"Delivered\", a message containing the updated envelope status and optionally the documents is sent to the URL. When an eventNotification is attached to an envelope using the API, it only applies to the envelope (treating the envelope as the sender). This is different from envelopes created through the console user interface, where the user is treated as the sender.")
public class EventNotification {
    private List<EnvelopeEvent> envelopeEvents = new ArrayList<EnvelopeEvent>();
    private String includeCertificateOfCompletion = null;
    private String includeCertificateWithSoap = null;
    private String includeDocumentFields = null;
    private String includeDocuments = null;
    private String includeEnvelopeVoidReason = null;
    private String includeSenderAccountAsCustomField = null;
    private String includeTimeZone = null;
    private String loggingEnabled = null;
    private List<RecipientEvent> recipientEvents = new ArrayList<RecipientEvent>();
    private String requireAcknowledgment = null;
    private String signMessageWithX509Cert = null;
    private String soapNameSpace = null;
    private String url = null;
    private String useSoapInterface = null;

    @ApiModelProperty(value="A list of envelope-level event statuses that will trigger Connect to send updates to the endpoint specified in the `url` property. \n\nTo receive notifications, you must include either an `envelopeEvents` node or a `recipientEvents` node. You do not need to specify both.")
    @JsonProperty(value="envelopeEvents")
    public List<EnvelopeEvent> getEnvelopeEvents() {
        return this.envelopeEvents;
    }

    public void setEnvelopeEvents(List<EnvelopeEvent> envelopeEvents) {
        this.envelopeEvents = envelopeEvents;
    }

    @ApiModelProperty(value="When set to **true**, the Connect Service includes the Certificate of Completion with completed envelopes.")
    @JsonProperty(value="includeCertificateOfCompletion")
    public String getIncludeCertificateOfCompletion() {
        return this.includeCertificateOfCompletion;
    }

    public void setIncludeCertificateOfCompletion(String includeCertificateOfCompletion) {
        this.includeCertificateOfCompletion = includeCertificateOfCompletion;
    }

    @ApiModelProperty(value="When set to **true**, this tells the Connect service to send the DocuSign signedby certificate as part of the outgoing SOAP xml. This appears in the XML as wsse:BinarySecurityToken.")
    @JsonProperty(value="includeCertificateWithSoap")
    public String getIncludeCertificateWithSoap() {
        return this.includeCertificateWithSoap;
    }

    public void setIncludeCertificateWithSoap(String includeCertificateWithSoap) {
        this.includeCertificateWithSoap = includeCertificateWithSoap;
    }

    @ApiModelProperty(value="When set to **true**, the Document Fields associated with envelope documents are included in the data. Document Fields are optional custom name-value pairs added to documents using the API.")
    @JsonProperty(value="includeDocumentFields")
    public String getIncludeDocumentFields() {
        return this.includeDocumentFields;
    }

    public void setIncludeDocumentFields(String includeDocumentFields) {
        this.includeDocumentFields = includeDocumentFields;
    }

    @ApiModelProperty(value="When set to **true**, the PDF documents are included in the message along with the updated XML.")
    @JsonProperty(value="includeDocuments")
    public String getIncludeDocuments() {
        return this.includeDocuments;
    }

    public void setIncludeDocuments(String includeDocuments) {
        this.includeDocuments = includeDocuments;
    }

    @ApiModelProperty(value="When set to **true**, this tells the Connect Service to include the void reason, as entered by the person that voided the envelope, in the message.")
    @JsonProperty(value="includeEnvelopeVoidReason")
    public String getIncludeEnvelopeVoidReason() {
        return this.includeEnvelopeVoidReason;
    }

    public void setIncludeEnvelopeVoidReason(String includeEnvelopeVoidReason) {
        this.includeEnvelopeVoidReason = includeEnvelopeVoidReason;
    }

    @ApiModelProperty(value="When set to **true**, the sender account ID is included as a envelope custom field in the data.")
    @JsonProperty(value="includeSenderAccountAsCustomField")
    public String getIncludeSenderAccountAsCustomField() {
        return this.includeSenderAccountAsCustomField;
    }

    public void setIncludeSenderAccountAsCustomField(String includeSenderAccountAsCustomField) {
        this.includeSenderAccountAsCustomField = includeSenderAccountAsCustomField;
    }

    @ApiModelProperty(value="When set to **true**, the envelope time zone information is included in the message.")
    @JsonProperty(value="includeTimeZone")
    public String getIncludeTimeZone() {
        return this.includeTimeZone;
    }

    public void setIncludeTimeZone(String includeTimeZone) {
        this.includeTimeZone = includeTimeZone;
    }

    @ApiModelProperty(value="When set to **true**, logging is turned on for envelope events on the Web Console Connect page.")
    @JsonProperty(value="loggingEnabled")
    public String getLoggingEnabled() {
        return this.loggingEnabled;
    }

    public void setLoggingEnabled(String loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    @ApiModelProperty(value="A list of recipient event statuses that will trigger Connect to send updates to   the endpoint specified in the url property.\n\nTo receive notifications, you must include either an `envelopeEvents` node or a `recipientEvents` node. You do not need to specify both.")
    @JsonProperty(value="recipientEvents")
    public List<RecipientEvent> getRecipientEvents() {
        return this.recipientEvents;
    }

    public void setRecipientEvents(List<RecipientEvent> recipientEvents) {
        this.recipientEvents = recipientEvents;
    }

    @ApiModelProperty(value="When set to **true**, the DocuSign Connect service checks that the message was received and retries on failures.")
    @JsonProperty(value="requireAcknowledgment")
    public String getRequireAcknowledgment() {
        return this.requireAcknowledgment;
    }

    public void setRequireAcknowledgment(String requireAcknowledgment) {
        this.requireAcknowledgment = requireAcknowledgment;
    }

    @ApiModelProperty(value="When set to **true**, messages are signed with an X509 certificate. This provides support for 2-way SSL in the envelope.")
    @JsonProperty(value="signMessageWithX509Cert")
    public String getSignMessageWithX509Cert() {
        return this.signMessageWithX509Cert;
    }

    public void setSignMessageWithX509Cert(String signMessageWithX509Cert) {
        this.signMessageWithX509Cert = signMessageWithX509Cert;
    }

    @ApiModelProperty(value="This lists the namespace in the SOAP listener provided.")
    @JsonProperty(value="soapNameSpace")
    public String getSoapNameSpace() {
        return this.soapNameSpace;
    }

    public void setSoapNameSpace(String soapNameSpace) {
        this.soapNameSpace = soapNameSpace;
    }

    @ApiModelProperty(value="Specifies the endpoint to which envelope updates are sent. Udpates are sent as XML unless `useSoapInterface` property is set to **true**.")
    @JsonProperty(value="url")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    @ApiModelProperty(value="When set to **true**, this tells the Connect service that the user's endpoint has implemented a SOAP interface.")
    @JsonProperty(value="useSoapInterface")
    public String getUseSoapInterface() {
        return this.useSoapInterface;
    }

    public void setUseSoapInterface(String useSoapInterface) {
        this.useSoapInterface = useSoapInterface;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EventNotification eventNotification = (EventNotification)o;
        return Objects.equals(this.envelopeEvents, eventNotification.envelopeEvents) && Objects.equals(this.includeCertificateOfCompletion, eventNotification.includeCertificateOfCompletion) && Objects.equals(this.includeCertificateWithSoap, eventNotification.includeCertificateWithSoap) && Objects.equals(this.includeDocumentFields, eventNotification.includeDocumentFields) && Objects.equals(this.includeDocuments, eventNotification.includeDocuments) && Objects.equals(this.includeEnvelopeVoidReason, eventNotification.includeEnvelopeVoidReason) && Objects.equals(this.includeSenderAccountAsCustomField, eventNotification.includeSenderAccountAsCustomField) && Objects.equals(this.includeTimeZone, eventNotification.includeTimeZone) && Objects.equals(this.loggingEnabled, eventNotification.loggingEnabled) && Objects.equals(this.recipientEvents, eventNotification.recipientEvents) && Objects.equals(this.requireAcknowledgment, eventNotification.requireAcknowledgment) && Objects.equals(this.signMessageWithX509Cert, eventNotification.signMessageWithX509Cert) && Objects.equals(this.soapNameSpace, eventNotification.soapNameSpace) && Objects.equals(this.url, eventNotification.url) && Objects.equals(this.useSoapInterface, eventNotification.useSoapInterface);
    }

    public int hashCode() {
        return Objects.hash(this.envelopeEvents, this.includeCertificateOfCompletion, this.includeCertificateWithSoap, this.includeDocumentFields, this.includeDocuments, this.includeEnvelopeVoidReason, this.includeSenderAccountAsCustomField, this.includeTimeZone, this.loggingEnabled, this.recipientEvents, this.requireAcknowledgment, this.signMessageWithX509Cert, this.soapNameSpace, this.url, this.useSoapInterface);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EventNotification {\n");
        if (this.envelopeEvents != null) {
            sb.append("    envelopeEvents: ").append(this.toIndentedString(this.envelopeEvents)).append("\n");
        }
        if (this.includeCertificateOfCompletion != null) {
            sb.append("    includeCertificateOfCompletion: ").append(this.toIndentedString(this.includeCertificateOfCompletion)).append("\n");
        }
        if (this.includeCertificateWithSoap != null) {
            sb.append("    includeCertificateWithSoap: ").append(this.toIndentedString(this.includeCertificateWithSoap)).append("\n");
        }
        if (this.includeDocumentFields != null) {
            sb.append("    includeDocumentFields: ").append(this.toIndentedString(this.includeDocumentFields)).append("\n");
        }
        if (this.includeDocuments != null) {
            sb.append("    includeDocuments: ").append(this.toIndentedString(this.includeDocuments)).append("\n");
        }
        if (this.includeEnvelopeVoidReason != null) {
            sb.append("    includeEnvelopeVoidReason: ").append(this.toIndentedString(this.includeEnvelopeVoidReason)).append("\n");
        }
        if (this.includeSenderAccountAsCustomField != null) {
            sb.append("    includeSenderAccountAsCustomField: ").append(this.toIndentedString(this.includeSenderAccountAsCustomField)).append("\n");
        }
        if (this.includeTimeZone != null) {
            sb.append("    includeTimeZone: ").append(this.toIndentedString(this.includeTimeZone)).append("\n");
        }
        if (this.loggingEnabled != null) {
            sb.append("    loggingEnabled: ").append(this.toIndentedString(this.loggingEnabled)).append("\n");
        }
        if (this.recipientEvents != null) {
            sb.append("    recipientEvents: ").append(this.toIndentedString(this.recipientEvents)).append("\n");
        }
        if (this.requireAcknowledgment != null) {
            sb.append("    requireAcknowledgment: ").append(this.toIndentedString(this.requireAcknowledgment)).append("\n");
        }
        if (this.signMessageWithX509Cert != null) {
            sb.append("    signMessageWithX509Cert: ").append(this.toIndentedString(this.signMessageWithX509Cert)).append("\n");
        }
        if (this.soapNameSpace != null) {
            sb.append("    soapNameSpace: ").append(this.toIndentedString(this.soapNameSpace)).append("\n");
        }
        if (this.url != null) {
            sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        }
        if (this.useSoapInterface != null) {
            sb.append("    useSoapInterface: ").append(this.toIndentedString(this.useSoapInterface)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

