/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.ErrorDetails;
import com.docusign.esign.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class LockInformation {
    private ErrorDetails errorDetails = null;
    private String lockDurationInSeconds = null;
    private String lockedByApp = null;
    private UserInfo lockedByUser = null;
    private String lockedUntilDateTime = null;
    private String lockToken = null;
    private String lockType = null;
    private String useScratchPad = null;

    @ApiModelProperty(value="")
    @JsonProperty(value="errorDetails")
    public ErrorDetails getErrorDetails() {
        return this.errorDetails;
    }

    public void setErrorDetails(ErrorDetails errorDetails) {
        this.errorDetails = errorDetails;
    }

    @ApiModelProperty(value="Sets the time, in seconds, until the lock expires when there is no activity on the envelope.\n\nIf no value is entered, then the default value of 300 seconds is used. The maximum value is 1,800 seconds.\n\nThe lock duration can be extended.")
    @JsonProperty(value="lockDurationInSeconds")
    public String getLockDurationInSeconds() {
        return this.lockDurationInSeconds;
    }

    public void setLockDurationInSeconds(String lockDurationInSeconds) {
        this.lockDurationInSeconds = lockDurationInSeconds;
    }

    @ApiModelProperty(value="Specifies the friendly name of  the application that is locking the envelope.")
    @JsonProperty(value="lockedByApp")
    public String getLockedByApp() {
        return this.lockedByApp;
    }

    public void setLockedByApp(String lockedByApp) {
        this.lockedByApp = lockedByApp;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="lockedByUser")
    public UserInfo getLockedByUser() {
        return this.lockedByUser;
    }

    public void setLockedByUser(UserInfo lockedByUser) {
        this.lockedByUser = lockedByUser;
    }

    @ApiModelProperty(value="The datetime until the envelope lock expires.")
    @JsonProperty(value="lockedUntilDateTime")
    public String getLockedUntilDateTime() {
        return this.lockedUntilDateTime;
    }

    public void setLockedUntilDateTime(String lockedUntilDateTime) {
        this.lockedUntilDateTime = lockedUntilDateTime;
    }

    @ApiModelProperty(value="A unique identifier provided to the owner of the envelope lock.   Used to prove ownership of the lock.")
    @JsonProperty(value="lockToken")
    public String getLockToken() {
        return this.lockToken;
    }

    public void setLockToken(String lockToken) {
        this.lockToken = lockToken;
    }

    @ApiModelProperty(value="The type of envelope lock.  Currently \"edit\" is the only supported type.")
    @JsonProperty(value="lockType")
    public String getLockType() {
        return this.lockType;
    }

    public void setLockType(String lockType) {
        this.lockType = lockType;
    }

    @ApiModelProperty(value="Reserved for future use.\n\nIndicates whether a scratchpad is used for editing information.")
    @JsonProperty(value="useScratchPad")
    public String getUseScratchPad() {
        return this.useScratchPad;
    }

    public void setUseScratchPad(String useScratchPad) {
        this.useScratchPad = useScratchPad;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LockInformation lockInformation = (LockInformation)o;
        return Objects.equals(this.errorDetails, lockInformation.errorDetails) && Objects.equals(this.lockDurationInSeconds, lockInformation.lockDurationInSeconds) && Objects.equals(this.lockedByApp, lockInformation.lockedByApp) && Objects.equals(this.lockedByUser, lockInformation.lockedByUser) && Objects.equals(this.lockedUntilDateTime, lockInformation.lockedUntilDateTime) && Objects.equals(this.lockToken, lockInformation.lockToken) && Objects.equals(this.lockType, lockInformation.lockType) && Objects.equals(this.useScratchPad, lockInformation.useScratchPad);
    }

    public int hashCode() {
        return Objects.hash(this.errorDetails, this.lockDurationInSeconds, this.lockedByApp, this.lockedByUser, this.lockedUntilDateTime, this.lockToken, this.lockType, this.useScratchPad);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LockInformation {\n");
        if (this.errorDetails != null) {
            sb.append("    errorDetails: ").append(this.toIndentedString(this.errorDetails)).append("\n");
        }
        if (this.lockDurationInSeconds != null) {
            sb.append("    lockDurationInSeconds: ").append(this.toIndentedString(this.lockDurationInSeconds)).append("\n");
        }
        if (this.lockedByApp != null) {
            sb.append("    lockedByApp: ").append(this.toIndentedString(this.lockedByApp)).append("\n");
        }
        if (this.lockedByUser != null) {
            sb.append("    lockedByUser: ").append(this.toIndentedString(this.lockedByUser)).append("\n");
        }
        if (this.lockedUntilDateTime != null) {
            sb.append("    lockedUntilDateTime: ").append(this.toIndentedString(this.lockedUntilDateTime)).append("\n");
        }
        if (this.lockToken != null) {
            sb.append("    lockToken: ").append(this.toIndentedString(this.lockToken)).append("\n");
        }
        if (this.lockType != null) {
            sb.append("    lockType: ").append(this.toIndentedString(this.lockType)).append("\n");
        }
        if (this.useScratchPad != null) {
            sb.append("    useScratchPad: ").append(this.toIndentedString(this.useScratchPad)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

