/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains information for transfering values between Salesforce data fields and DocuSign Tabs.")
public class MergeField {
    private String allowSenderToEdit = null;
    private String configurationType = null;
    private String _path = null;
    private String row = null;
    private String writeBack = null;

    @ApiModelProperty(value="When set to **true**, the sender can modify the value of the custom tab during the sending process.")
    @JsonProperty(value="allowSenderToEdit")
    public String getAllowSenderToEdit() {
        return this.allowSenderToEdit;
    }

    public void setAllowSenderToEdit(String allowSenderToEdit) {
        this.allowSenderToEdit = allowSenderToEdit;
    }

    @ApiModelProperty(value="If merge field's are being used, specifies the type of the merge field. The only  supported value is **salesforce**.")
    @JsonProperty(value="configurationType")
    public String getConfigurationType() {
        return this.configurationType;
    }

    public void setConfigurationType(String configurationType) {
        this.configurationType = configurationType;
    }

    @ApiModelProperty(value="Sets the object associated with the custom tab. Currently this is the Salesforce Object.")
    @JsonProperty(value="path")
    public String getPath() {
        return this._path;
    }

    public void setPath(String _path) {
        this._path = _path;
    }

    @ApiModelProperty(value="Specifies the row number in a Salesforce table that the merge field value corresponds to.")
    @JsonProperty(value="row")
    public String getRow() {
        return this.row;
    }

    public void setRow(String row) {
        this.row = row;
    }

    @ApiModelProperty(value="When wet to true, the information entered in the tab automatically updates the related Salesforce data when an envelope is completed.")
    @JsonProperty(value="writeBack")
    public String getWriteBack() {
        return this.writeBack;
    }

    public void setWriteBack(String writeBack) {
        this.writeBack = writeBack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MergeField mergeField = (MergeField)o;
        return Objects.equals(this.allowSenderToEdit, mergeField.allowSenderToEdit) && Objects.equals(this.configurationType, mergeField.configurationType) && Objects.equals(this._path, mergeField._path) && Objects.equals(this.row, mergeField.row) && Objects.equals(this.writeBack, mergeField.writeBack);
    }

    public int hashCode() {
        return Objects.hash(this.allowSenderToEdit, this.configurationType, this._path, this.row, this.writeBack);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MergeField {\n");
        if (this.allowSenderToEdit != null) {
            sb.append("    allowSenderToEdit: ").append(this.toIndentedString(this.allowSenderToEdit)).append("\n");
        }
        if (this.configurationType != null) {
            sb.append("    configurationType: ").append(this.toIndentedString(this.configurationType)).append("\n");
        }
        if (this._path != null) {
            sb.append("    _path: ").append(this.toIndentedString(this._path)).append("\n");
        }
        if (this.row != null) {
            sb.append("    row: ").append(this.toIndentedString(this.row)).append("\n");
        }
        if (this.writeBack != null) {
            sb.append("    writeBack: ").append(this.toIndentedString(this.writeBack)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

