/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AddOn;
import com.docusign.esign.model.FeatureSet;
import com.docusign.esign.model.RecipientDomain;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="An object used to identify the features and attributes of the account being created.")
public class PlanInformation {
    private List<AddOn> addOns = new ArrayList<AddOn>();
    private String currencyCode = null;
    private String freeTrialDaysOverride = null;
    private List<FeatureSet> planFeatureSets = new ArrayList<FeatureSet>();
    private String planId = null;
    private List<RecipientDomain> recipientDomains = new ArrayList<RecipientDomain>();

    @ApiModelProperty(value="Reserved:")
    @JsonProperty(value="addOns")
    public List<AddOn> getAddOns() {
        return this.addOns;
    }

    public void setAddOns(List<AddOn> addOns) {
        this.addOns = addOns;
    }

    @ApiModelProperty(value="Specifies the ISO currency code for the account.")
    @JsonProperty(value="currencyCode")
    public String getCurrencyCode() {
        return this.currencyCode;
    }

    public void setCurrencyCode(String currencyCode) {
        this.currencyCode = currencyCode;
    }

    @ApiModelProperty(value="Reserved for DocuSign use only.")
    @JsonProperty(value="freeTrialDaysOverride")
    public String getFreeTrialDaysOverride() {
        return this.freeTrialDaysOverride;
    }

    public void setFreeTrialDaysOverride(String freeTrialDaysOverride) {
        this.freeTrialDaysOverride = freeTrialDaysOverride;
    }

    @ApiModelProperty(value="A complex type that sets the feature sets for the account.")
    @JsonProperty(value="planFeatureSets")
    public List<FeatureSet> getPlanFeatureSets() {
        return this.planFeatureSets;
    }

    public void setPlanFeatureSets(List<FeatureSet> planFeatureSets) {
        this.planFeatureSets = planFeatureSets;
    }

    @ApiModelProperty(value="The DocuSign Plan ID for the account.")
    @JsonProperty(value="planId")
    public String getPlanId() {
        return this.planId;
    }

    public void setPlanId(String planId) {
        this.planId = planId;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="recipientDomains")
    public List<RecipientDomain> getRecipientDomains() {
        return this.recipientDomains;
    }

    public void setRecipientDomains(List<RecipientDomain> recipientDomains) {
        this.recipientDomains = recipientDomains;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanInformation planInformation = (PlanInformation)o;
        return Objects.equals(this.addOns, planInformation.addOns) && Objects.equals(this.currencyCode, planInformation.currencyCode) && Objects.equals(this.freeTrialDaysOverride, planInformation.freeTrialDaysOverride) && Objects.equals(this.planFeatureSets, planInformation.planFeatureSets) && Objects.equals(this.planId, planInformation.planId) && Objects.equals(this.recipientDomains, planInformation.recipientDomains);
    }

    public int hashCode() {
        return Objects.hash(this.addOns, this.currencyCode, this.freeTrialDaysOverride, this.planFeatureSets, this.planId, this.recipientDomains);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlanInformation {\n");
        if (this.addOns != null) {
            sb.append("    addOns: ").append(this.toIndentedString(this.addOns)).append("\n");
        }
        if (this.currencyCode != null) {
            sb.append("    currencyCode: ").append(this.toIndentedString(this.currencyCode)).append("\n");
        }
        if (this.freeTrialDaysOverride != null) {
            sb.append("    freeTrialDaysOverride: ").append(this.toIndentedString(this.freeTrialDaysOverride)).append("\n");
        }
        if (this.planFeatureSets != null) {
            sb.append("    planFeatureSets: ").append(this.toIndentedString(this.planFeatureSets)).append("\n");
        }
        if (this.planId != null) {
            sb.append("    planId: ").append(this.toIndentedString(this.planId)).append("\n");
        }
        if (this.recipientDomains != null) {
            sb.append("    recipientDomains: ").append(this.toIndentedString(this.recipientDomains)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

