/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="An array of email notifications that specifies the email the user receives when they are a sender. When the specific email notification is set to true, the user receives those types of email notifications from DocuSign. The user inherits the default account sender email notification settings when the user is created.")
public class SignerEmailNotifications {
    private String agentNotification = null;
    private String carbonCopyNotification = null;
    private String certifiedDeliveryNotification = null;
    private String documentMarkupActivation = null;
    private String envelopeActivation = null;
    private String envelopeComplete = null;
    private String envelopeCorrected = null;
    private String envelopeDeclined = null;
    private String envelopeVoided = null;
    private String faxReceived = null;
    private String offlineSigningFailed = null;
    private String purgeDocuments = null;
    private String reassignedSigner = null;
    private String whenSigningGroupMember = null;

    @ApiModelProperty(value="When set to **true**, the user receives agent notification emails.")
    @JsonProperty(value="agentNotification")
    public String getAgentNotification() {
        return this.agentNotification;
    }

    public void setAgentNotification(String agentNotification) {
        this.agentNotification = agentNotification;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notifications of carbon copy deliveries.")
    @JsonProperty(value="carbonCopyNotification")
    public String getCarbonCopyNotification() {
        return this.carbonCopyNotification;
    }

    public void setCarbonCopyNotification(String carbonCopyNotification) {
        this.carbonCopyNotification = carbonCopyNotification;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notifications of certified deliveries.")
    @JsonProperty(value="certifiedDeliveryNotification")
    public String getCertifiedDeliveryNotification() {
        return this.certifiedDeliveryNotification;
    }

    public void setCertifiedDeliveryNotification(String certifiedDeliveryNotification) {
        this.certifiedDeliveryNotification = certifiedDeliveryNotification;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notification that document markup has been activated.")
    @JsonProperty(value="documentMarkupActivation")
    public String getDocumentMarkupActivation() {
        return this.documentMarkupActivation;
    }

    public void setDocumentMarkupActivation(String documentMarkupActivation) {
        this.documentMarkupActivation = documentMarkupActivation;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notification that the envelope has been activated.")
    @JsonProperty(value="envelopeActivation")
    public String getEnvelopeActivation() {
        return this.envelopeActivation;
    }

    public void setEnvelopeActivation(String envelopeActivation) {
        this.envelopeActivation = envelopeActivation;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notification that the envelope has been completed.")
    @JsonProperty(value="envelopeComplete")
    public String getEnvelopeComplete() {
        return this.envelopeComplete;
    }

    public void setEnvelopeComplete(String envelopeComplete) {
        this.envelopeComplete = envelopeComplete;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notification that the envelope has been corrected.")
    @JsonProperty(value="envelopeCorrected")
    public String getEnvelopeCorrected() {
        return this.envelopeCorrected;
    }

    public void setEnvelopeCorrected(String envelopeCorrected) {
        this.envelopeCorrected = envelopeCorrected;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notification that the envelope has been declined.")
    @JsonProperty(value="envelopeDeclined")
    public String getEnvelopeDeclined() {
        return this.envelopeDeclined;
    }

    public void setEnvelopeDeclined(String envelopeDeclined) {
        this.envelopeDeclined = envelopeDeclined;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notification that the envelope has been voided.")
    @JsonProperty(value="envelopeVoided")
    public String getEnvelopeVoided() {
        return this.envelopeVoided;
    }

    public void setEnvelopeVoided(String envelopeVoided) {
        this.envelopeVoided = envelopeVoided;
    }

    @ApiModelProperty(value="Reserved:")
    @JsonProperty(value="faxReceived")
    public String getFaxReceived() {
        return this.faxReceived;
    }

    public void setFaxReceived(String faxReceived) {
        this.faxReceived = faxReceived;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notification if the offline signing failed.")
    @JsonProperty(value="offlineSigningFailed")
    public String getOfflineSigningFailed() {
        return this.offlineSigningFailed;
    }

    public void setOfflineSigningFailed(String offlineSigningFailed) {
        this.offlineSigningFailed = offlineSigningFailed;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notification of document purges.")
    @JsonProperty(value="purgeDocuments")
    public String getPurgeDocuments() {
        return this.purgeDocuments;
    }

    public void setPurgeDocuments(String purgeDocuments) {
        this.purgeDocuments = purgeDocuments;
    }

    @ApiModelProperty(value="When set to **true**, the user receives notification that the envelope has been reassigned.")
    @JsonProperty(value="reassignedSigner")
    public String getReassignedSigner() {
        return this.reassignedSigner;
    }

    public void setReassignedSigner(String reassignedSigner) {
        this.reassignedSigner = reassignedSigner;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="whenSigningGroupMember")
    public String getWhenSigningGroupMember() {
        return this.whenSigningGroupMember;
    }

    public void setWhenSigningGroupMember(String whenSigningGroupMember) {
        this.whenSigningGroupMember = whenSigningGroupMember;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SignerEmailNotifications signerEmailNotifications = (SignerEmailNotifications)o;
        return Objects.equals(this.agentNotification, signerEmailNotifications.agentNotification) && Objects.equals(this.carbonCopyNotification, signerEmailNotifications.carbonCopyNotification) && Objects.equals(this.certifiedDeliveryNotification, signerEmailNotifications.certifiedDeliveryNotification) && Objects.equals(this.documentMarkupActivation, signerEmailNotifications.documentMarkupActivation) && Objects.equals(this.envelopeActivation, signerEmailNotifications.envelopeActivation) && Objects.equals(this.envelopeComplete, signerEmailNotifications.envelopeComplete) && Objects.equals(this.envelopeCorrected, signerEmailNotifications.envelopeCorrected) && Objects.equals(this.envelopeDeclined, signerEmailNotifications.envelopeDeclined) && Objects.equals(this.envelopeVoided, signerEmailNotifications.envelopeVoided) && Objects.equals(this.faxReceived, signerEmailNotifications.faxReceived) && Objects.equals(this.offlineSigningFailed, signerEmailNotifications.offlineSigningFailed) && Objects.equals(this.purgeDocuments, signerEmailNotifications.purgeDocuments) && Objects.equals(this.reassignedSigner, signerEmailNotifications.reassignedSigner) && Objects.equals(this.whenSigningGroupMember, signerEmailNotifications.whenSigningGroupMember);
    }

    public int hashCode() {
        return Objects.hash(this.agentNotification, this.carbonCopyNotification, this.certifiedDeliveryNotification, this.documentMarkupActivation, this.envelopeActivation, this.envelopeComplete, this.envelopeCorrected, this.envelopeDeclined, this.envelopeVoided, this.faxReceived, this.offlineSigningFailed, this.purgeDocuments, this.reassignedSigner, this.whenSigningGroupMember);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SignerEmailNotifications {\n");
        if (this.agentNotification != null) {
            sb.append("    agentNotification: ").append(this.toIndentedString(this.agentNotification)).append("\n");
        }
        if (this.carbonCopyNotification != null) {
            sb.append("    carbonCopyNotification: ").append(this.toIndentedString(this.carbonCopyNotification)).append("\n");
        }
        if (this.certifiedDeliveryNotification != null) {
            sb.append("    certifiedDeliveryNotification: ").append(this.toIndentedString(this.certifiedDeliveryNotification)).append("\n");
        }
        if (this.documentMarkupActivation != null) {
            sb.append("    documentMarkupActivation: ").append(this.toIndentedString(this.documentMarkupActivation)).append("\n");
        }
        if (this.envelopeActivation != null) {
            sb.append("    envelopeActivation: ").append(this.toIndentedString(this.envelopeActivation)).append("\n");
        }
        if (this.envelopeComplete != null) {
            sb.append("    envelopeComplete: ").append(this.toIndentedString(this.envelopeComplete)).append("\n");
        }
        if (this.envelopeCorrected != null) {
            sb.append("    envelopeCorrected: ").append(this.toIndentedString(this.envelopeCorrected)).append("\n");
        }
        if (this.envelopeDeclined != null) {
            sb.append("    envelopeDeclined: ").append(this.toIndentedString(this.envelopeDeclined)).append("\n");
        }
        if (this.envelopeVoided != null) {
            sb.append("    envelopeVoided: ").append(this.toIndentedString(this.envelopeVoided)).append("\n");
        }
        if (this.faxReceived != null) {
            sb.append("    faxReceived: ").append(this.toIndentedString(this.faxReceived)).append("\n");
        }
        if (this.offlineSigningFailed != null) {
            sb.append("    offlineSigningFailed: ").append(this.toIndentedString(this.offlineSigningFailed)).append("\n");
        }
        if (this.purgeDocuments != null) {
            sb.append("    purgeDocuments: ").append(this.toIndentedString(this.purgeDocuments)).append("\n");
        }
        if (this.reassignedSigner != null) {
            sb.append("    reassignedSigner: ").append(this.toIndentedString(this.reassignedSigner)).append("\n");
        }
        if (this.whenSigningGroupMember != null) {
            sb.append("    whenSigningGroupMember: ").append(this.toIndentedString(this.whenSigningGroupMember)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

