/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="A complex element consisting of: \n\n* lastSentDateTime \u2013 the date and time the user last sent an envelope. \n* lastSignedDateTime \u2013 the date and time the user last signed an envelope.\n* sentCount \u2013 the number of envelopes the user has sent.\n* signedCount \u2013 the number of envelopes the user has signed.")
public class UsageHistory {
    private String lastSentDateTime = null;
    private String lastSignedDateTime = null;
    private Integer sentCount = null;
    private Integer signedCount = null;

    @ApiModelProperty(value="The date and time the user last sent an envelope.")
    @JsonProperty(value="lastSentDateTime")
    public String getLastSentDateTime() {
        return this.lastSentDateTime;
    }

    public void setLastSentDateTime(String lastSentDateTime) {
        this.lastSentDateTime = lastSentDateTime;
    }

    @ApiModelProperty(value="The date and time the user last signed an envelope.")
    @JsonProperty(value="lastSignedDateTime")
    public String getLastSignedDateTime() {
        return this.lastSignedDateTime;
    }

    public void setLastSignedDateTime(String lastSignedDateTime) {
        this.lastSignedDateTime = lastSignedDateTime;
    }

    @ApiModelProperty(value="The number of envelopes the user has sent.")
    @JsonProperty(value="sentCount")
    public Integer getSentCount() {
        return this.sentCount;
    }

    public void setSentCount(Integer sentCount) {
        this.sentCount = sentCount;
    }

    @ApiModelProperty(value="The number of envelopes the user has signed.")
    @JsonProperty(value="signedCount")
    public Integer getSignedCount() {
        return this.signedCount;
    }

    public void setSignedCount(Integer signedCount) {
        this.signedCount = signedCount;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UsageHistory usageHistory = (UsageHistory)o;
        return Objects.equals(this.lastSentDateTime, usageHistory.lastSentDateTime) && Objects.equals(this.lastSignedDateTime, usageHistory.lastSignedDateTime) && Objects.equals(this.sentCount, usageHistory.sentCount) && Objects.equals(this.signedCount, usageHistory.signedCount);
    }

    public int hashCode() {
        return Objects.hash(this.lastSentDateTime, this.lastSignedDateTime, this.sentCount, this.signedCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UsageHistory {\n");
        if (this.lastSentDateTime != null) {
            sb.append("    lastSentDateTime: ").append(this.toIndentedString(this.lastSentDateTime)).append("\n");
        }
        if (this.lastSignedDateTime != null) {
            sb.append("    lastSignedDateTime: ").append(this.toIndentedString(this.lastSignedDateTime)).append("\n");
        }
        if (this.sentCount != null) {
            sb.append("    sentCount: ").append(this.toIndentedString(this.sentCount)).append("\n");
        }
        if (this.signedCount != null) {
            sb.append("    signedCount: ").append(this.toIndentedString(this.signedCount)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

