/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.WorkspaceItem;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Provides properties that describe the contents of a workspace folder.")
public class WorkspaceFolderContents {
    private String endPosition = null;
    private WorkspaceItem folder = null;
    private List<WorkspaceItem> items = new ArrayList<WorkspaceItem>();
    private List<WorkspaceItem> parentFolders = new ArrayList<WorkspaceItem>();
    private String resultSetSize = null;
    private String startPosition = null;
    private String totalSetSize = null;
    private String workspaceId = null;

    @ApiModelProperty(value="The last position in the result set.")
    @JsonProperty(value="endPosition")
    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="folder")
    public WorkspaceItem getFolder() {
        return this.folder;
    }

    public void setFolder(WorkspaceItem folder) {
        this.folder = folder;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="items")
    public List<WorkspaceItem> getItems() {
        return this.items;
    }

    public void setItems(List<WorkspaceItem> items) {
        this.items = items;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="parentFolders")
    public List<WorkspaceItem> getParentFolders() {
        return this.parentFolders;
    }

    public void setParentFolders(List<WorkspaceItem> parentFolders) {
        this.parentFolders = parentFolders;
    }

    @ApiModelProperty(value="The number of results returned in this response.")
    @JsonProperty(value="resultSetSize")
    public String getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    @ApiModelProperty(value="Starting position of the current result set.")
    @JsonProperty(value="startPosition")
    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    @ApiModelProperty(value="The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.")
    @JsonProperty(value="totalSetSize")
    public String getTotalSetSize() {
        return this.totalSetSize;
    }

    public void setTotalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
    }

    @ApiModelProperty(value="The id of the workspace, always populated.")
    @JsonProperty(value="workspaceId")
    public String getWorkspaceId() {
        return this.workspaceId;
    }

    public void setWorkspaceId(String workspaceId) {
        this.workspaceId = workspaceId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceFolderContents workspaceFolderContents = (WorkspaceFolderContents)o;
        return Objects.equals(this.endPosition, workspaceFolderContents.endPosition) && Objects.equals(this.folder, workspaceFolderContents.folder) && Objects.equals(this.items, workspaceFolderContents.items) && Objects.equals(this.parentFolders, workspaceFolderContents.parentFolders) && Objects.equals(this.resultSetSize, workspaceFolderContents.resultSetSize) && Objects.equals(this.startPosition, workspaceFolderContents.startPosition) && Objects.equals(this.totalSetSize, workspaceFolderContents.totalSetSize) && Objects.equals(this.workspaceId, workspaceFolderContents.workspaceId);
    }

    public int hashCode() {
        return Objects.hash(this.endPosition, this.folder, this.items, this.parentFolders, this.resultSetSize, this.startPosition, this.totalSetSize, this.workspaceId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkspaceFolderContents {\n");
        if (this.endPosition != null) {
            sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        }
        if (this.folder != null) {
            sb.append("    folder: ").append(this.toIndentedString(this.folder)).append("\n");
        }
        if (this.items != null) {
            sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        }
        if (this.parentFolders != null) {
            sb.append("    parentFolders: ").append(this.toIndentedString(this.parentFolders)).append("\n");
        }
        if (this.resultSetSize != null) {
            sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        }
        if (this.startPosition != null) {
            sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        }
        if (this.totalSetSize != null) {
            sb.append("    totalSetSize: ").append(this.toIndentedString(this.totalSetSize)).append("\n");
        }
        if (this.workspaceId != null) {
            sb.append("    workspaceId: ").append(this.toIndentedString(this.workspaceId)).append("\n");
        }
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

