/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.client.auth;

import com.docusign.esign.client.Pair;
import com.docusign.esign.client.auth.AccessTokenListener;
import com.docusign.esign.client.auth.Authentication;
import com.docusign.esign.client.auth.OAuthFlow;
import com.docusign.esign.client.auth.OAuthJerseyClient;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientHandlerException;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Response;
import org.apache.oltu.oauth2.client.HttpClient;
import org.apache.oltu.oauth2.client.OAuthClient;
import org.apache.oltu.oauth2.client.request.OAuthClientRequest;
import org.apache.oltu.oauth2.client.response.OAuthJSONAccessTokenResponse;
import org.apache.oltu.oauth2.common.message.types.GrantType;
import org.apache.oltu.oauth2.common.message.types.ResponseType;
import org.apache.oltu.oauth2.common.token.BasicOAuthToken;

public class OAuth
implements Authentication {
    static final int MILLIS_PER_SECOND = 1000;
    private volatile String accessToken;
    private Long expirationTimeMillis;
    private OAuthClient oauthClient;
    private OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder;
    private OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder;
    private AccessTokenListener accessTokenListener;

    public OAuth(Client client, OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder, OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder) {
        this.oauthClient = new OAuthClient((HttpClient)new OAuthJerseyClient(client));
        this.tokenRequestBuilder = tokenRequestBuilder;
        this.authenticationRequestBuilder = authenticationRequestBuilder;
    }

    public OAuth(Client client, OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this(client, OAuthClientRequest.tokenLocation((String)tokenUrl).setScope(scopes), OAuthClientRequest.authorizationLocation((String)authorizationUrl).setScope(scopes));
        switch (flow) {
            case accessCode: {
                this.tokenRequestBuilder.setGrantType(GrantType.AUTHORIZATION_CODE);
                this.authenticationRequestBuilder.setResponseType(ResponseType.CODE.name().toLowerCase());
                break;
            }
            case implicit: {
                this.tokenRequestBuilder.setGrantType(GrantType.IMPLICIT);
                this.authenticationRequestBuilder.setResponseType(ResponseType.TOKEN.name().toLowerCase());
                break;
            }
            case password: {
                this.tokenRequestBuilder.setGrantType(GrantType.PASSWORD);
                break;
            }
            case application: {
                this.tokenRequestBuilder.setGrantType(GrantType.CLIENT_CREDENTIALS);
                break;
            }
        }
    }

    public OAuth(OAuthFlow flow, String authorizationUrl, String tokenUrl, String scopes) {
        this(new Client(null, null), flow, authorizationUrl, tokenUrl, scopes);
    }

    @Override
    public void applyToParams(List<Pair> queryParams, Map<String, String> headerParams) {
        if (headerParams.containsKey("Authorization")) {
            return;
        }
        if (this.expirationTimeMillis == null || System.currentTimeMillis() >= this.expirationTimeMillis) {
            this.updateAccessToken();
        }
        if (this.accessToken != null) {
            headerParams.put("Authorization", "Bearer " + this.accessToken);
        }
    }

    public synchronized void updateAccessToken() {
        OAuthJSONAccessTokenResponse accessTokenResponse;
        try {
            accessTokenResponse = this.oauthClient.accessToken(this.tokenRequestBuilder.buildBodyMessage());
        }
        catch (Exception e) {
            throw new ClientHandlerException(e.getMessage(), (Throwable)e);
        }
        if (accessTokenResponse != null) {
            if (accessTokenResponse.getResponseCode() != Response.Status.OK.getStatusCode()) {
                throw new ClientHandlerException("Error while requesting an access token, received HTTP code: " + accessTokenResponse.getResponseCode());
            }
            if (accessTokenResponse.getAccessToken() == null) {
                throw new ClientHandlerException("Error while requesting an access token. No 'access_token' found.");
            }
            if (accessTokenResponse.getExpiresIn() == null) {
                throw new ClientHandlerException("Error while requesting an access token. No 'expires_in' found.");
            }
            this.setAccessToken(accessTokenResponse.getAccessToken(), accessTokenResponse.getExpiresIn());
            if (this.accessTokenListener != null) {
                this.accessTokenListener.notify((BasicOAuthToken)accessTokenResponse.getOAuthToken());
            }
        } else {
            throw new ClientHandlerException("Error while requesting an access token. No accessTokenResponse object recieved, maybe a non HTTP 200 received?");
        }
    }

    public synchronized void registerAccessTokenListener(AccessTokenListener accessTokenListener) {
        this.accessTokenListener = accessTokenListener;
    }

    public synchronized String getAccessToken() {
        return this.accessToken;
    }

    public synchronized void setAccessToken(String accessToken, Long expiresIn) {
        this.accessToken = accessToken;
        this.expirationTimeMillis = System.currentTimeMillis() + expiresIn * 1000L;
    }

    public OAuthClientRequest.TokenRequestBuilder getTokenRequestBuilder() {
        return this.tokenRequestBuilder;
    }

    public void setTokenRequestBuilder(OAuthClientRequest.TokenRequestBuilder tokenRequestBuilder) {
        this.tokenRequestBuilder = tokenRequestBuilder;
    }

    public OAuthClientRequest.AuthenticationRequestBuilder getAuthenticationRequestBuilder() {
        return this.authenticationRequestBuilder;
    }

    public void setAuthenticationRequestBuilder(OAuthClientRequest.AuthenticationRequestBuilder authenticationRequestBuilder) {
        this.authenticationRequestBuilder = authenticationRequestBuilder;
    }

    public OAuthClient getOauthClient() {
        return this.oauthClient;
    }

    public void setOauthClient(OAuthClient oauthClient) {
        this.oauthClient = oauthClient;
    }

    public void setOauthClient(Client client) {
        this.oauthClient = new OAuthClient((HttpClient)new OAuthJerseyClient(client));
    }
}

