/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.AccountAddress;
import com.docusign.esign.model.AccountBillingPlan;
import com.docusign.esign.model.BillingPlan;
import com.docusign.esign.model.CreditCardInformation;
import com.docusign.esign.model.DirectDebitProcessorInformation;
import com.docusign.esign.model.PaymentProcessorInformation;
import com.docusign.esign.model.ReferralInformation;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="Defines an account billing plan response object.")
public class AccountBillingPlanResponse {
    @JsonProperty(value="billingAddress")
    private AccountAddress billingAddress = null;
    @JsonProperty(value="billingAddressIsCreditCardAddress")
    private String billingAddressIsCreditCardAddress = null;
    @JsonProperty(value="billingPlan")
    private AccountBillingPlan billingPlan = null;
    @JsonProperty(value="creditCardInformation")
    private CreditCardInformation creditCardInformation = null;
    @JsonProperty(value="directDebitProcessorInformation")
    private DirectDebitProcessorInformation directDebitProcessorInformation = null;
    @JsonProperty(value="paymentMethod")
    private String paymentMethod = null;
    @JsonProperty(value="paymentProcessorInformation")
    private PaymentProcessorInformation paymentProcessorInformation = null;
    @JsonProperty(value="referralInformation")
    private ReferralInformation referralInformation = null;
    @JsonProperty(value="successorPlans")
    private List<BillingPlan> successorPlans = new ArrayList<BillingPlan>();

    public AccountBillingPlanResponse billingAddress(AccountAddress billingAddress) {
        this.billingAddress = billingAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public AccountAddress getBillingAddress() {
        return this.billingAddress;
    }

    public void setBillingAddress(AccountAddress billingAddress) {
        this.billingAddress = billingAddress;
    }

    public AccountBillingPlanResponse billingAddressIsCreditCardAddress(String billingAddressIsCreditCardAddress) {
        this.billingAddressIsCreditCardAddress = billingAddressIsCreditCardAddress;
        return this;
    }

    @ApiModelProperty(example="null", value="When set to **true**, the credit card address information is the same as that returned as the billing address. If false, then the billing address is considered a billing contact address, and the credit card address can be different.")
    public String getBillingAddressIsCreditCardAddress() {
        return this.billingAddressIsCreditCardAddress;
    }

    public void setBillingAddressIsCreditCardAddress(String billingAddressIsCreditCardAddress) {
        this.billingAddressIsCreditCardAddress = billingAddressIsCreditCardAddress;
    }

    public AccountBillingPlanResponse billingPlan(AccountBillingPlan billingPlan) {
        this.billingPlan = billingPlan;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public AccountBillingPlan getBillingPlan() {
        return this.billingPlan;
    }

    public void setBillingPlan(AccountBillingPlan billingPlan) {
        this.billingPlan = billingPlan;
    }

    public AccountBillingPlanResponse creditCardInformation(CreditCardInformation creditCardInformation) {
        this.creditCardInformation = creditCardInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public CreditCardInformation getCreditCardInformation() {
        return this.creditCardInformation;
    }

    public void setCreditCardInformation(CreditCardInformation creditCardInformation) {
        this.creditCardInformation = creditCardInformation;
    }

    public AccountBillingPlanResponse directDebitProcessorInformation(DirectDebitProcessorInformation directDebitProcessorInformation) {
        this.directDebitProcessorInformation = directDebitProcessorInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public DirectDebitProcessorInformation getDirectDebitProcessorInformation() {
        return this.directDebitProcessorInformation;
    }

    public void setDirectDebitProcessorInformation(DirectDebitProcessorInformation directDebitProcessorInformation) {
        this.directDebitProcessorInformation = directDebitProcessorInformation;
    }

    public AccountBillingPlanResponse paymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(String paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public AccountBillingPlanResponse paymentProcessorInformation(PaymentProcessorInformation paymentProcessorInformation) {
        this.paymentProcessorInformation = paymentProcessorInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public PaymentProcessorInformation getPaymentProcessorInformation() {
        return this.paymentProcessorInformation;
    }

    public void setPaymentProcessorInformation(PaymentProcessorInformation paymentProcessorInformation) {
        this.paymentProcessorInformation = paymentProcessorInformation;
    }

    public AccountBillingPlanResponse referralInformation(ReferralInformation referralInformation) {
        this.referralInformation = referralInformation;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public ReferralInformation getReferralInformation() {
        return this.referralInformation;
    }

    public void setReferralInformation(ReferralInformation referralInformation) {
        this.referralInformation = referralInformation;
    }

    public AccountBillingPlanResponse successorPlans(List<BillingPlan> successorPlans) {
        this.successorPlans = successorPlans;
        return this;
    }

    public AccountBillingPlanResponse addSuccessorPlansItem(BillingPlan successorPlansItem) {
        this.successorPlans.add(successorPlansItem);
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public List<BillingPlan> getSuccessorPlans() {
        return this.successorPlans;
    }

    public void setSuccessorPlans(List<BillingPlan> successorPlans) {
        this.successorPlans = successorPlans;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountBillingPlanResponse accountBillingPlanResponse = (AccountBillingPlanResponse)o;
        return Objects.equals(this.billingAddress, accountBillingPlanResponse.billingAddress) && Objects.equals(this.billingAddressIsCreditCardAddress, accountBillingPlanResponse.billingAddressIsCreditCardAddress) && Objects.equals(this.billingPlan, accountBillingPlanResponse.billingPlan) && Objects.equals(this.creditCardInformation, accountBillingPlanResponse.creditCardInformation) && Objects.equals(this.directDebitProcessorInformation, accountBillingPlanResponse.directDebitProcessorInformation) && Objects.equals(this.paymentMethod, accountBillingPlanResponse.paymentMethod) && Objects.equals(this.paymentProcessorInformation, accountBillingPlanResponse.paymentProcessorInformation) && Objects.equals(this.referralInformation, accountBillingPlanResponse.referralInformation) && Objects.equals(this.successorPlans, accountBillingPlanResponse.successorPlans);
    }

    public int hashCode() {
        return Objects.hash(this.billingAddress, this.billingAddressIsCreditCardAddress, this.billingPlan, this.creditCardInformation, this.directDebitProcessorInformation, this.paymentMethod, this.paymentProcessorInformation, this.referralInformation, this.successorPlans);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AccountBillingPlanResponse {\n");
        sb.append("    billingAddress: ").append(this.toIndentedString(this.billingAddress)).append("\n");
        sb.append("    billingAddressIsCreditCardAddress: ").append(this.toIndentedString(this.billingAddressIsCreditCardAddress)).append("\n");
        sb.append("    billingPlan: ").append(this.toIndentedString(this.billingPlan)).append("\n");
        sb.append("    creditCardInformation: ").append(this.toIndentedString(this.creditCardInformation)).append("\n");
        sb.append("    directDebitProcessorInformation: ").append(this.toIndentedString(this.directDebitProcessorInformation)).append("\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString(this.paymentMethod)).append("\n");
        sb.append("    paymentProcessorInformation: ").append(this.toIndentedString(this.paymentProcessorInformation)).append("\n");
        sb.append("    referralInformation: ").append(this.toIndentedString(this.referralInformation)).append("\n");
        sb.append("    successorPlans: ").append(this.toIndentedString(this.successorPlans)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

