/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

@ApiModel(description="Contains address information.")
public class AddressInformation {
    @JsonProperty(value="address1")
    private String address1 = null;
    @JsonProperty(value="address2")
    private String address2 = null;
    @JsonProperty(value="city")
    private String city = null;
    @JsonProperty(value="country")
    private String country = null;
    @JsonProperty(value="fax")
    private String fax = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="postalCode")
    private String postalCode = null;
    @JsonProperty(value="stateOrProvince")
    private String stateOrProvince = null;

    public AddressInformation address1(String address1) {
        this.address1 = address1;
        return this;
    }

    @ApiModelProperty(example="null", value="First Line of the address. Maximum length: 100 characters.")
    public String getAddress1() {
        return this.address1;
    }

    public void setAddress1(String address1) {
        this.address1 = address1;
    }

    public AddressInformation address2(String address2) {
        this.address2 = address2;
        return this;
    }

    @ApiModelProperty(example="null", value="Second Line of the address. Maximum length: 100 characters.")
    public String getAddress2() {
        return this.address2;
    }

    public void setAddress2(String address2) {
        this.address2 = address2;
    }

    public AddressInformation city(String city) {
        this.city = city;
        return this;
    }

    @ApiModelProperty(example="null", value="The city associated with the address.")
    public String getCity() {
        return this.city;
    }

    public void setCity(String city) {
        this.city = city;
    }

    public AddressInformation country(String country) {
        this.country = country;
        return this;
    }

    @ApiModelProperty(example="null", value="Specifies the country associated with the address.")
    public String getCountry() {
        return this.country;
    }

    public void setCountry(String country) {
        this.country = country;
    }

    public AddressInformation fax(String fax) {
        this.fax = fax;
        return this;
    }

    @ApiModelProperty(example="null", value="A Fax number associated with the address if one is available.")
    public String getFax() {
        return this.fax;
    }

    public void setFax(String fax) {
        this.fax = fax;
    }

    public AddressInformation phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(example="null", value="A phone number associated with the address.")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public AddressInformation postalCode(String postalCode) {
        this.postalCode = postalCode;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
    }

    public AddressInformation stateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
        return this;
    }

    @ApiModelProperty(example="null", value="")
    public String getStateOrProvince() {
        return this.stateOrProvince;
    }

    public void setStateOrProvince(String stateOrProvince) {
        this.stateOrProvince = stateOrProvince;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AddressInformation addressInformation = (AddressInformation)o;
        return Objects.equals(this.address1, addressInformation.address1) && Objects.equals(this.address2, addressInformation.address2) && Objects.equals(this.city, addressInformation.city) && Objects.equals(this.country, addressInformation.country) && Objects.equals(this.fax, addressInformation.fax) && Objects.equals(this.phone, addressInformation.phone) && Objects.equals(this.postalCode, addressInformation.postalCode) && Objects.equals(this.stateOrProvince, addressInformation.stateOrProvince);
    }

    public int hashCode() {
        return Objects.hash(this.address1, this.address2, this.city, this.country, this.fax, this.phone, this.postalCode, this.stateOrProvince);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class AddressInformation {\n");
        sb.append("    address1: ").append(this.toIndentedString(this.address1)).append("\n");
        sb.append("    address2: ").append(this.toIndentedString(this.address2)).append("\n");
        sb.append("    city: ").append(this.toIndentedString(this.city)).append("\n");
        sb.append("    country: ").append(this.toIndentedString(this.country)).append("\n");
        sb.append("    fax: ").append(this.toIndentedString(this.fax)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    postalCode: ").append(this.toIndentedString(this.postalCode)).append("\n");
        sb.append("    stateOrProvince: ").append(this.toIndentedString(this.stateOrProvince)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

