/*
 * Decompiled with CFR 0.152.
 */
package com.docusign.esign.model;

import com.docusign.esign.model.Workspace;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="Provides properties that describe the workspaces avaialble.")
public class WorkspaceList
implements Serializable {
    private static final long serialVersionUID = 1L;
    @JsonProperty(value="endPosition")
    private String endPosition = null;
    @JsonProperty(value="resultSetSize")
    private String resultSetSize = null;
    @JsonProperty(value="startPosition")
    private String startPosition = null;
    @JsonProperty(value="totalSetSize")
    private String totalSetSize = null;
    @JsonProperty(value="workspaces")
    private List<Workspace> workspaces = null;

    public WorkspaceList endPosition(String endPosition) {
        this.endPosition = endPosition;
        return this;
    }

    @Schema(description="The last position in the result set. ")
    public String getEndPosition() {
        return this.endPosition;
    }

    public void setEndPosition(String endPosition) {
        this.endPosition = endPosition;
    }

    public WorkspaceList resultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
        return this;
    }

    @Schema(description="The number of results returned in this response. ")
    public String getResultSetSize() {
        return this.resultSetSize;
    }

    public void setResultSetSize(String resultSetSize) {
        this.resultSetSize = resultSetSize;
    }

    public WorkspaceList startPosition(String startPosition) {
        this.startPosition = startPosition;
        return this;
    }

    @Schema(description="Starting position of the current result set.")
    public String getStartPosition() {
        return this.startPosition;
    }

    public void setStartPosition(String startPosition) {
        this.startPosition = startPosition;
    }

    public WorkspaceList totalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
        return this;
    }

    @Schema(description="The total number of items available in the result set. This will always be greater than or equal to the value of the property returning the results in the in the response.")
    public String getTotalSetSize() {
        return this.totalSetSize;
    }

    public void setTotalSetSize(String totalSetSize) {
        this.totalSetSize = totalSetSize;
    }

    public WorkspaceList workspaces(List<Workspace> workspaces) {
        this.workspaces = workspaces;
        return this;
    }

    public WorkspaceList addWorkspacesItem(Workspace workspacesItem) {
        if (this.workspaces == null) {
            this.workspaces = new ArrayList<Workspace>();
        }
        this.workspaces.add(workspacesItem);
        return this;
    }

    @Schema(description="A list of workspaces.")
    public List<Workspace> getWorkspaces() {
        return this.workspaces;
    }

    public void setWorkspaces(List<Workspace> workspaces) {
        this.workspaces = workspaces;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WorkspaceList workspaceList = (WorkspaceList)o;
        return Objects.equals(this.endPosition, workspaceList.endPosition) && Objects.equals(this.resultSetSize, workspaceList.resultSetSize) && Objects.equals(this.startPosition, workspaceList.startPosition) && Objects.equals(this.totalSetSize, workspaceList.totalSetSize) && Objects.equals(this.workspaces, workspaceList.workspaces);
    }

    public int hashCode() {
        return Objects.hash(this.endPosition, this.resultSetSize, this.startPosition, this.totalSetSize, this.workspaces);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class WorkspaceList {\n");
        sb.append("    endPosition: ").append(this.toIndentedString(this.endPosition)).append("\n");
        sb.append("    resultSetSize: ").append(this.toIndentedString(this.resultSetSize)).append("\n");
        sb.append("    startPosition: ").append(this.toIndentedString(this.startPosition)).append("\n");
        sb.append("    totalSetSize: ").append(this.toIndentedString(this.totalSetSize)).append("\n");
        sb.append("    workspaces: ").append(this.toIndentedString(this.workspaces)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

