/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.executor;

import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProcessStreamProxy
extends Thread {
    private final InputStream is;
    private final OutputStream os;
    private final CountDownLatch startUpLatch = new CountDownLatch(1);
    private final CountDownLatch shutDownLatch = new CountDownLatch(1);
    private AtomicBoolean running = new AtomicBoolean(false);

    public ProcessStreamProxy(String processName, InputStream inputStreamFromConsole, OutputStream outputStreamToProcess) {
        if (inputStreamFromConsole.equals(System.in)) {
            try {
                Class<?> console = Class.forName("dorkbox.console.Console");
                Method inputStream = console.getDeclaredMethod("inputStream", new Class[0]);
                InputStream invoked = (InputStream)inputStream.invoke(console, new Object[0]);
                Field in = FilterInputStream.class.getDeclaredField("in");
                in.setAccessible(true);
                Object unwrapped = in.get(inputStreamFromConsole);
                while (unwrapped instanceof FilterInputStream) {
                    unwrapped = in.get(unwrapped);
                }
                if (unwrapped instanceof FileInputStream && ((FileInputStream)unwrapped).getFD().equals(FileDescriptor.in)) {
                    inputStreamFromConsole = invoked;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.is = inputStreamFromConsole;
        this.os = outputStreamToProcess;
        this.setName(processName);
        this.setDaemon(true);
    }

    @Override
    public synchronized void start() {
        super.start();
        try {
            this.startUpLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void close() {
        this.running.set(false);
        try {
            this.is.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            this.shutDownLatch.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.running.set(true);
        this.startUpLatch.countDown();
        InputStream is = this.is;
        OutputStream os = this.os;
        try {
            if (os == null) {
                while (is.read() != -1 && this.running.get()) {
                }
            } else {
                int readInt;
                while ((readInt = is.read()) != -1 && this.running.get()) {
                    os.write(readInt);
                    if (readInt != 10) continue;
                    os.flush();
                    OutputStream outputStream = os;
                    synchronized (outputStream) {
                        os.notifyAll();
                    }
                }
            }
        }
        catch (Exception e) {
        }
        finally {
            try {
                if (os != null) {
                    os.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.shutDownLatch.countDown();
        }
    }
}

