/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core;

import java.util.Objects;

public class Version {
    private int majorVersion;
    private int minorVersion;
    private int patchVersion;

    public Version(int majorVersion, int minorVersion, int patchVersion) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getPatchVersion() {
        return this.patchVersion;
    }

    public int compareTo(Version other) {
        if (this.majorVersion != other.majorVersion) {
            return this.majorVersion - other.majorVersion;
        }
        if (this.minorVersion != other.minorVersion) {
            return this.minorVersion - other.minorVersion;
        }
        return this.patchVersion - other.patchVersion;
    }

    public boolean isGreaterThan(Version other) {
        return this.compareTo(other) > 0;
    }

    public boolean isGreaterThanOrEqual(Version other) {
        return this.compareTo(other) >= 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Version version = (Version)o;
        return this.majorVersion == version.majorVersion && this.minorVersion == version.minorVersion && this.patchVersion == version.patchVersion;
    }

    public int hashCode() {
        return Objects.hash(this.majorVersion, this.minorVersion, this.patchVersion);
    }
}

