/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.core.condition.impl.dialect;

import com.dynamic.sql.core.Fn;
import com.dynamic.sql.core.Version;
import com.dynamic.sql.core.column.conventional.Column;
import com.dynamic.sql.core.column.function.ColumFunction;
import com.dynamic.sql.core.condition.impl.dialect.GenericWhereCondition;
import com.dynamic.sql.enums.LogicalOperatorType;
import com.dynamic.sql.enums.SqlDialect;
import com.dynamic.sql.model.TableAliasMapping;
import com.dynamic.sql.utils.SqlUtils;
import java.util.Map;

public class MysqlWhereCondition
extends GenericWhereCondition {
    public MysqlWhereCondition(Version version, Map<String, TableAliasMapping> aliasTableMap, String dataSourceName) {
        super(version, aliasTableMap, dataSourceName);
    }

    @Override
    protected SqlDialect sqlDialect() {
        return SqlDialect.MYSQL;
    }

    @Override
    public <T, F> GenericWhereCondition andMatches(Fn<T, F> fn, String regex) {
        return this.matches(LogicalOperatorType.AND, fn, regex);
    }

    @Override
    public GenericWhereCondition andMatches(Column column, String value) {
        return this.matches(LogicalOperatorType.AND, column, value);
    }

    @Override
    public <T, F> GenericWhereCondition orMatches(Fn<T, F> fn, String regex) {
        return this.matches(LogicalOperatorType.OR, fn, regex);
    }

    @Override
    public GenericWhereCondition orMatches(Column column, String value) {
        return this.matches(LogicalOperatorType.OR, column, value);
    }

    public <T, F> GenericWhereCondition matches(LogicalOperatorType logicalOperatorType, Fn<T, F> fn, String regex) {
        String column = SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName);
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, fn, regex);
        this.condition.append(" ").append(this.logicalOperatorType(logicalOperatorType));
        if (this.version.isGreaterThanOrEqual(new Version(8, 0, 0))) {
            this.condition.append(" regexp_like(").append(column).append(", ").append(key).append(")");
            return this;
        }
        this.condition.append(" ").append(column).append(" regexp ").append(key);
        return this;
    }

    public GenericWhereCondition matches(LogicalOperatorType logicalOperatorType, Column column, String regex) {
        String functionToString = column.getFunctionToString(this.sqlDialect(), this.version, this.aliasTableMap);
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, regex);
        this.condition.append(" ").append(this.logicalOperatorType(logicalOperatorType));
        if (this.version.isGreaterThanOrEqual(new Version(8, 0, 0))) {
            this.condition.append(" regexp_like(").append(functionToString).append(", ").append(key).append(")");
            return this;
        }
        this.condition.append(" ").append(functionToString).append(" regexp ").append(key);
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andMatches(Fn<T, F> fn, ColumFunction columFunction) {
        return this.matchesFunction(LogicalOperatorType.AND, fn, columFunction);
    }

    @Override
    public <T, F> GenericWhereCondition orMatches(Fn<T, F> fn, ColumFunction columFunction) {
        return this.matchesFunction(LogicalOperatorType.OR, fn, columFunction);
    }

    public <T, F> GenericWhereCondition matchesFunction(LogicalOperatorType logicalOperatorType, Fn<T, F> fn, ColumFunction columFunction) {
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        String column = SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName);
        this.condition.append(" ").append(this.logicalOperatorType(logicalOperatorType));
        if (this.version.isGreaterThanOrEqual(new Version(8, 0, 0))) {
            this.condition.append(" regexp_like(").append(column).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, columFunction.getFunctionToString(this.sqlDialect(), this.version, this.aliasTableMap))).append(")");
            return this;
        }
        this.condition.append(" ").append(column).append(" regexp ").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, columFunction.getFunctionToString(this.sqlDialect(), this.version, this.aliasTableMap)));
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andFindInSet(Fn<T, F> fn, Object item) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, item)).append(", ").append(SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition andFindInSet(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String functionToString = column.getFunctionToString(this.sqlDialect(), this.version, this.aliasTableMap);
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(" find_in_set(").append(key).append(", ").append(functionToString).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andFindInSet(Fn<T, F> fn, Object item, String separator) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        String column = SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName);
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, item)).append(", ").append("replace(").append(column).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, separator)).append(", ',')").append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orFindInSet(Fn<T, F> fn, Object item) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, item)).append(", ").append(SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition orFindInSet(Column column, Object value) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String functionToString = column.getFunctionToString(this.sqlDialect(), this.version, this.aliasTableMap);
        String key = SqlUtils.registerValueWithKey(this.parameterBinder, value);
        this.condition.append(" find_in_set(").append(key).append(", ").append(functionToString).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orFindInSet(Fn<T, F> fn, Object item, String separator) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        String column = SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName);
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, item)).append(", ").append("replace(").append(column).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, separator)).append(", ',')").append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition andFindInSet(Fn<T, F> fn, ColumFunction columFunction) {
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.AND));
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, columFunction.getFunctionToString(this.sqlDialect(), this.version, this.aliasTableMap))).append(", ").append(SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName)).append(")");
        return this;
    }

    @Override
    public <T, F> GenericWhereCondition orFindInSet(Fn<T, F> fn, ColumFunction columFunction) {
        this.parameterBinder.addParameterBinder(columFunction.getParameterBinder());
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" find_in_set(").append(SqlUtils.registerValueWithKey(this.parameterBinder, fn, columFunction.getFunctionToString(this.sqlDialect(), this.version, this.aliasTableMap))).append(", ").append(SqlUtils.extractQualifiedAlias(fn, (Map<String, TableAliasMapping>)this.aliasTableMap, this.dataSourceName)).append(")");
        return this;
    }

    @Override
    public GenericWhereCondition limit(int limit) {
        return this.limit(0, limit);
    }

    @Override
    public GenericWhereCondition limit(int offset, int limit) {
        this.condition.append(" ").append(this.logicalOperatorType(LogicalOperatorType.OR));
        this.condition.append(" limit ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, offset)).append(", ").append(SqlUtils.registerValueWithKey(this.parameterBinder, null, limit));
        return this;
    }
}

