/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.model;

import com.dynamic.sql.plugins.conversion.AttributeConverter;
import com.dynamic.sql.utils.WKBUtils;
import java.io.Serializable;
import java.nio.ByteOrder;
import java.util.Objects;
import javax.annotation.Nonnull;

public class Point
implements AttributeConverter<Point, byte[]>,
Serializable {
    private static final long serialVersionUID = 4902022702746614570L;
    private double longitude;
    private double latitude;
    private int srid;
    private ByteOrder byteOrder;

    private Point() {
    }

    public Point(double longitude, double latitude) {
        this(longitude, latitude, 0);
    }

    public Point(double longitude, double latitude, int srid) {
        this(longitude, latitude, srid, null);
    }

    public Point(double longitude, double latitude, int srid, ByteOrder byteOrder) {
        this.longitude = longitude;
        this.latitude = latitude;
        this.srid = srid;
        this.byteOrder = byteOrder;
    }

    public Point(@Nonnull Point point) {
        this(point.getLongitude(), point.getLatitude(), point.getSrid(), point.getByteOrder());
    }

    public double getLongitude() {
        return this.longitude;
    }

    public void setLongitude(double longitude) {
        this.longitude = longitude;
    }

    public double getLatitude() {
        return this.latitude;
    }

    public void setLatitude(double latitude) {
        this.latitude = latitude;
    }

    public int getSrid() {
        return this.srid;
    }

    public void setSrid(int srid) {
        this.srid = srid;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public void setByteOrder(ByteOrder byteOrder) {
        this.byteOrder = byteOrder;
    }

    public String toPointString() {
        return "POINT(" + this.longitude + " " + this.latitude + ")";
    }

    public int hashCode() {
        return Objects.hash(this.longitude, this.latitude, this.srid, this.byteOrder);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Point other = (Point)obj;
        return Double.compare(other.longitude, this.longitude) == 0 && Double.compare(other.latitude, this.latitude) == 0 && this.srid == other.srid && this.byteOrder == other.byteOrder;
    }

    public String toString() {
        return "SRID=" + this.srid + "; " + this.toPointString() + (this.byteOrder != null ? "; ByteOrder=" + this.byteOrder : "");
    }

    @Override
    public byte[] convertToDatabaseColumn(Point point) {
        return WKBUtils.writeWkbBytesFromPoint(point);
    }

    @Override
    public Point convertToEntityAttribute(byte[] dbData) {
        return WKBUtils.readPointFromWkbBytes(dbData);
    }
}

