/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    public static <T> List<List<T>> partition(Collection<T> collection, int size) {
        if (collection == null || collection.isEmpty()) {
            return new ArrayList<List<T>>();
        }
        if (size <= 0) {
            throw new IllegalArgumentException("\u5206\u5272\u5927\u5c0f\u5fc5\u987b\u5927\u4e8e 0: " + size);
        }
        List<Object> list = collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection);
        int total = list.size();
        int groupCount = (total + size - 1) / size;
        ArrayList<List<T>> result = new ArrayList<List<T>>(groupCount);
        for (int i = 0; i < total; i += size) {
            int end = Math.min(i + size, total);
            result.add(new ArrayList(list.subList(i, end)));
        }
        return result;
    }
}

