/*
 * Decompiled with CFR 0.152.
 */
package com.dynamic.sql.utils;

import com.dynamic.sql.utils.CollectionUtils;
import com.dynamic.sql.utils.NamingUtils;
import java.util.Collection;

public class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str == null || (strLen = str.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(str.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static boolean isEquals(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equals(str2);
    }

    public static boolean isNotEquals(String str1, String str2) {
        return !StringUtils.isEquals(str1, str2);
    }

    public static boolean isEqualsIgnoreCase(String str1, String str2) {
        if (str1 == null) {
            return str2 == null;
        }
        return str1.equalsIgnoreCase(str2);
    }

    public static boolean isNotEqualsIgnoreCase(String str1, String str2) {
        return !StringUtils.isEqualsIgnoreCase(str1, str2);
    }

    public static String join(CharSequence delimiter, Collection<?> collection) {
        if (CollectionUtils.isEmpty(collection)) {
            return "";
        }
        return StringUtils.join(delimiter, collection.toArray());
    }

    public static String join(CharSequence delimiter, Object ... params) {
        if (params == null || params.length == 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param == null) {
                result.append("null");
            } else {
                result.append(param);
            }
            if (i >= params.length - 1) continue;
            result.append(delimiter);
        }
        return result.toString();
    }

    public static String bytesToHex(byte[] bytes) {
        return StringUtils.bytesToHex(bytes, false);
    }

    public static String bytesToHex(byte[] bytes, boolean upperCase) {
        if (bytes == null || bytes.length == 0) {
            return "";
        }
        StringBuilder hexStringBuilder = new StringBuilder();
        for (byte b : bytes) {
            hexStringBuilder.append(String.format(upperCase ? "%02X" : "%02x", b));
        }
        return hexStringBuilder.toString();
    }

    public static byte[] hexToBytes(String hex) {
        if (hex == null || hex.isEmpty()) {
            return new byte[0];
        }
        if (hex.length() % 2 != 0) {
            throw new IllegalArgumentException("\u5341\u516d\u8fdb\u5236\u5b57\u7b26\u4e32\u957f\u5ea6\u5fc5\u987b\u4e3a\u5076\u6570: " + hex);
        }
        int len = hex.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            String byteStr = hex.substring(i, i + 2);
            try {
                data[i / 2] = (byte)Integer.parseInt(byteStr, 16);
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("\u975e\u6cd5\u7684\u5341\u516d\u8fdb\u5236\u5b57\u7b26: " + byteStr, e);
            }
        }
        return data;
    }

    public static String toBaseString(int number, int base) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("\u8fdb\u5236\u5fc5\u987b\u5728 2~36 \u4e4b\u95f4: " + base);
        }
        return Integer.toString(number, base);
    }

    public static String toBaseString(long number, int base) {
        if (base < 2 || base > 36) {
            throw new IllegalArgumentException("\u8fdb\u5236\u5fc5\u987b\u5728 2~36 \u4e4b\u95f4: " + base);
        }
        return Long.toString(number, base);
    }

    public static boolean endsWith(String str, String suffix) {
        if (str == null || suffix == null) {
            return false;
        }
        return str.startsWith(suffix, str.length() - suffix.length());
    }

    public static String toCamelCase(String str) {
        return NamingUtils.snakeToCamelCase(str);
    }

    public static String toSnakeCase(String str) {
        return NamingUtils.camelToSnakeCase(str);
    }

    public static String reverse(String str) {
        if (str == null) {
            return null;
        }
        return new StringBuilder(str).reverse().toString();
    }

    public static boolean isNumeric(String str) {
        if (str == null || str.isEmpty()) {
            return false;
        }
        for (char c : str.toCharArray()) {
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String leftPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(size);
        for (int i = 0; i < pads; ++i) {
            sb.append(padChar);
        }
        sb.append(str);
        return sb.toString();
    }

    public static String rightPad(String str, int size, char padChar) {
        if (str == null) {
            return null;
        }
        int pads = size - str.length();
        if (pads <= 0) {
            return str;
        }
        StringBuilder sb = new StringBuilder(size);
        sb.append(str);
        for (int i = 0; i < pads; ++i) {
            sb.append(padChar);
        }
        return sb.toString();
    }
}

