/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.extension.window;

import com.easy.query.core.proxy.PropTypeColumn;

public class Offset<TProperty> {
    protected final int offset;
    private PropTypeColumn<TProperty> defaultColumn;
    private TProperty defaultValue;

    public Offset(int offset) {
        this.offset = offset;
    }

    public boolean isNext() {
        return this.offset >= 0;
    }

    public int getOffset() {
        return Math.abs(this.offset);
    }

    public PropTypeColumn<TProperty> getDefaultColumn() {
        return this.defaultColumn;
    }

    public void setDefaultColumn(PropTypeColumn<TProperty> defaultColumn) {
        this.defaultColumn = defaultColumn;
    }

    public TProperty getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(TProperty defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getSQLFunction() {
        return this.isNext() ? "LEAD" : "LAG";
    }

    public static <TProp> Offset<TProp> of(int offset) {
        return Offset.of(offset, null);
    }

    public static <TProp> Offset<TProp> of(int offset, PropTypeColumn<TProp> defaultColumn) {
        Offset<TProp> nextOffset = new Offset<TProp>(offset);
        nextOffset.setDefaultColumn(defaultColumn);
        return nextOffset;
    }

    public static <TProp> Offset<TProp> of(int offset, TProp defaultValue) {
        Offset<TProp> nextOffset = new Offset<TProp>(offset);
        nextOffset.setDefaultValue(defaultValue);
        return nextOffset;
    }
}

