/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.command;

import com.easy.query.api.proxy.entity.save.MemoryAddressCompareValue;
import com.easy.query.api.proxy.entity.save.PrimaryKeyInsertProcessor;
import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveBehavior;
import com.easy.query.api.proxy.entity.save.SaveBehaviorEnum;
import com.easy.query.api.proxy.entity.save.SaveCommandContext;
import com.easy.query.api.proxy.entity.save.SaveNode;
import com.easy.query.api.proxy.entity.save.SaveNodeDbTypeEnum;
import com.easy.query.api.proxy.entity.save.SaveNodeTypeEnum;
import com.easy.query.api.proxy.entity.save.command.SaveCommand;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.api.delete.ClientEntityDeletable;
import com.easy.query.core.basic.api.insert.ClientInsertable;
import com.easy.query.core.basic.api.update.ClientEntityUpdatable;
import com.easy.query.core.enums.CascadeTypeEnum;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public class BasicSaveCommand
implements SaveCommand {
    private final EntityMetadata entityMetadata;
    private final List<Object> inserts;
    private final List<Object> updates;
    private final EasyQueryClient easyQueryClient;
    private final SaveCommandContext saveCommandContext;
    private final SaveBehavior saveBehavior;
    private final boolean deleteAll;
    private final PrimaryKeyInsertProcessor primaryKeyInsertProcessor;

    public BasicSaveCommand(EntityMetadata entityMetadata, List<Object> inserts, List<Object> updates, EasyQueryClient easyQueryClient, SaveCommandContext saveCommandContext, SaveBehavior saveBehavior, boolean deleteAll, PrimaryKeyInsertProcessor primaryKeyInsertProcessor) {
        this.entityMetadata = entityMetadata;
        this.inserts = inserts;
        this.updates = updates;
        this.easyQueryClient = easyQueryClient;
        this.saveCommandContext = saveCommandContext;
        this.saveBehavior = saveBehavior;
        this.deleteAll = deleteAll;
        this.primaryKeyInsertProcessor = primaryKeyInsertProcessor;
    }

    @Override
    public void execute(boolean batch) {
        SaveNode saveNode;
        SavableContext savableContext;
        int i;
        List<SavableContext> savableContexts = this.saveCommandContext.getSavableContexts();
        for (i = savableContexts.size() - 1; i >= 0; --i) {
            savableContext = savableContexts.get(i);
            for (Map.Entry<NavigateMetadata, SaveNode> saveNodeEntry : savableContext.getSaveNodeMap().entrySet()) {
                String[] targetMappingProperties;
                String[] selfMappingProperties;
                saveNode = saveNodeEntry.getValue();
                List deleteItems = EasyCollectionUtil.mapFilterSelect(saveNode.getEntityItems(), kv -> ((SaveNode.EntitySaveSate)kv.getValue()).getType() == SaveNodeTypeEnum.DELETE && ((SaveNode.EntitySaveSate)kv.getValue()).getDbType() == SaveNodeDbTypeEnum.DELETE, kv -> {
                    ((SaveNode.EntitySaveSate)kv.getValue()).executeBefore(((MemoryAddressCompareValue)kv.getKey()).getEntity());
                    return ((MemoryAddressCompareValue)kv.getKey()).getEntity();
                });
                ((ClientEntityDeletable)((ClientEntityDeletable)this.easyQueryClient.deletable((Collection)deleteItems).batch(batch)).allowDeleteStatement(true)).executeRows();
                if (!EasyCollectionUtil.isNotEmpty(saveNode.getDeleteBys())) continue;
                NavigateMetadata navigateMetadata = saveNodeEntry.getKey();
                if (navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
                    selfMappingProperties = navigateMetadata.getSelfMappingProperties();
                    targetMappingProperties = navigateMetadata.getTargetMappingProperties();
                    ((ClientEntityDeletable)((ClientEntityDeletable)this.easyQueryClient.deletable(saveNode.getDeleteBys()).batch(batch)).allowDeleteStatement(true)).whereColumns(col -> {
                        for (String selfMappingProperty : selfMappingProperties) {
                            col.column(selfMappingProperty);
                        }
                        for (String targetMappingProperty : targetMappingProperties) {
                            col.column(targetMappingProperty);
                        }
                    }).executeRows();
                    continue;
                }
                if (navigateMetadata.getCascade() != CascadeTypeEnum.AUTO && navigateMetadata.getCascade() != CascadeTypeEnum.SET_NULL) continue;
                selfMappingProperties = navigateMetadata.getSelfMappingProperties();
                targetMappingProperties = navigateMetadata.getTargetMappingProperties();
                ((ClientEntityUpdatable)this.easyQueryClient.updatable(saveNode.getDeleteBys()).batch(batch)).setColumns(col -> {
                    for (String selfMappingProperty : selfMappingProperties) {
                        col.columnNull(selfMappingProperty);
                    }
                    for (String targetMappingProperty : targetMappingProperties) {
                        col.columnNull(targetMappingProperty);
                    }
                }).whereColumns(col -> {
                    for (String selfMappingProperty : selfMappingProperties) {
                        col.column(selfMappingProperty);
                    }
                    for (String targetMappingProperty : targetMappingProperties) {
                        col.column(targetMappingProperty);
                    }
                }).executeRows();
            }
        }
        if (this.deleteAll) {
            if (!this.saveBehavior.hasBehavior(SaveBehaviorEnum.ROOT_IGNORE)) {
                ((ClientEntityDeletable)((ClientEntityDeletable)this.easyQueryClient.deletable(this.updates).allowDeleteStatement(true)).batch(batch)).executeRows();
            }
        } else if (!this.saveBehavior.hasBehavior(SaveBehaviorEnum.ROOT_IGNORE)) {
            this.inserts.forEach(o -> this.setPrimaryKeyOnInsert(o, this.entityMetadata));
            ((ClientInsertable)this.easyQueryClient.insertable(this.inserts).batch(batch)).executeRows(this.insertFillAutoIncrement(this.entityMetadata));
            if (!this.saveBehavior.hasBehavior(SaveBehaviorEnum.ROOT_UPDATE_IGNORE)) {
                ((ClientEntityUpdatable)this.easyQueryClient.updatable(this.updates).batch(batch)).executeRows();
            }
        }
        for (i = 0; i < savableContexts.size(); ++i) {
            savableContext = savableContexts.get(i);
            for (Map.Entry<NavigateMetadata, SaveNode> nodeKv : savableContext.getSaveNodeMap().entrySet()) {
                saveNode = nodeKv.getValue();
                List insertItems = EasyCollectionUtil.mapFilterSelect(saveNode.getEntityItems(), kv -> ((SaveNode.EntitySaveSate)kv.getValue()).getType() == SaveNodeTypeEnum.INSERT, kv -> {
                    ((SaveNode.EntitySaveSate)kv.getValue()).executeBefore(((MemoryAddressCompareValue)kv.getKey()).getEntity());
                    Object entity = ((MemoryAddressCompareValue)kv.getKey()).getEntity();
                    this.setPrimaryKeyOnInsert(entity, saveNode.getEntityMetadata());
                    return entity;
                });
                ((ClientInsertable)this.easyQueryClient.insertable((Collection)insertItems).batch(batch)).executeRows(this.insertFillAutoIncrement(saveNode.getEntityMetadata()));
                List setNullItems = EasyCollectionUtil.mapFilterSelect(saveNode.getEntityItems(), kv -> ((SaveNode.EntitySaveSate)kv.getValue()).getType() == SaveNodeTypeEnum.DELETE && ((SaveNode.EntitySaveSate)kv.getValue()).getDbType() == SaveNodeDbTypeEnum.UPDATE, kv -> {
                    ((SaveNode.EntitySaveSate)kv.getValue()).executeBefore(((MemoryAddressCompareValue)kv.getKey()).getEntity());
                    return ((MemoryAddressCompareValue)kv.getKey()).getEntity();
                });
                ((ClientEntityUpdatable)this.easyQueryClient.updatable((Collection)setNullItems).batch(batch)).executeRows();
                List updateItems = EasyCollectionUtil.mapFilterSelect(saveNode.getEntityItems(), kv -> ((SaveNode.EntitySaveSate)kv.getValue()).getType() == SaveNodeTypeEnum.UPDATE || ((SaveNode.EntitySaveSate)kv.getValue()).getType() == SaveNodeTypeEnum.CHANGE, kv -> {
                    ((SaveNode.EntitySaveSate)kv.getValue()).executeBefore(((MemoryAddressCompareValue)kv.getKey()).getEntity());
                    return ((MemoryAddressCompareValue)kv.getKey()).getEntity();
                });
                ((ClientEntityUpdatable)this.easyQueryClient.updatable((Collection)updateItems).batch(batch)).executeRows();
            }
        }
    }

    private boolean insertFillAutoIncrement(EntityMetadata entityMetadata) {
        List generatedKeyColumns = entityMetadata.getGeneratedKeyColumns();
        return EasyCollectionUtil.isNotEmpty((Collection)generatedKeyColumns);
    }

    private void setPrimaryKeyOnInsert(Object entity, EntityMetadata entityMetadata) {
        this.primaryKeyInsertProcessor.setPrimaryKeyOnInsert(entity, entityMetadata);
    }
}

