/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.api.proxy.entity.save.provider;

import com.easy.query.api.proxy.entity.save.MemoryAddressCompareValue;
import com.easy.query.api.proxy.entity.save.PrimaryKeyInsertProcessor;
import com.easy.query.api.proxy.entity.save.SavableContext;
import com.easy.query.api.proxy.entity.save.SaveBehavior;
import com.easy.query.api.proxy.entity.save.SaveBehaviorEnum;
import com.easy.query.api.proxy.entity.save.SaveCommandContext;
import com.easy.query.api.proxy.entity.save.TargetValueTypeEnum;
import com.easy.query.api.proxy.entity.save.provider.DeleteValueObject;
import com.easy.query.api.proxy.entity.save.provider.SaveProvider;
import com.easy.query.core.api.client.EasyQueryClient;
import com.easy.query.core.basic.extension.track.EntityState;
import com.easy.query.core.basic.extension.track.TrackContext;
import com.easy.query.core.context.QueryRuntimeContext;
import com.easy.query.core.enums.CascadeTypeEnum;
import com.easy.query.core.enums.RelationTypeEnum;
import com.easy.query.core.exception.EasyQueryInvalidOperationException;
import com.easy.query.core.expression.lambda.Property;
import com.easy.query.core.metadata.ColumnMetadata;
import com.easy.query.core.metadata.EntityMetadata;
import com.easy.query.core.metadata.EntityMetadataManager;
import com.easy.query.core.metadata.NavigateMetadata;
import com.easy.query.core.util.EasyArrayUtil;
import com.easy.query.core.util.EasyClassUtil;
import com.easy.query.core.util.EasyCollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractSaveProvider
implements SaveProvider {
    protected final Class<?> entityClass;
    protected final List<Object> entities;
    protected final EasyQueryClient easyQueryClient;
    protected final QueryRuntimeContext runtimeContext;
    protected final EntityMetadataManager entityMetadataManager;
    protected final TrackContext currentTrackContext;
    protected final SaveBehavior saveBehavior;
    protected final boolean removeRoot;
    protected final PrimaryKeyInsertProcessor primaryKeyInsertProcessor;
    protected final List<Set<String>> savePathLimit;
    protected final Map<MemoryAddressCompareValue, DeleteValueObject> deleteValueObjectMap;
    protected final SaveCommandContext saveCommandContext;

    public AbstractSaveProvider(TrackContext currentTrackContext, Class<?> entityClass, List<Object> entities, EasyQueryClient easyQueryClient, List<Set<String>> savePathLimit, SaveBehavior saveBehavior, boolean removeRoot, PrimaryKeyInsertProcessor primaryKeyInsertProcessor) {
        this.entityClass = entityClass;
        this.entities = entities;
        this.easyQueryClient = easyQueryClient;
        this.runtimeContext = easyQueryClient.getRuntimeContext();
        this.currentTrackContext = currentTrackContext;
        this.saveBehavior = saveBehavior;
        this.removeRoot = removeRoot;
        this.primaryKeyInsertProcessor = primaryKeyInsertProcessor;
        this.entityMetadataManager = this.runtimeContext.getEntityMetadataManager();
        this.savePathLimit = savePathLimit;
        this.saveCommandContext = new SaveCommandContext(entityClass);
        this.deleteValueObjectMap = new LinkedHashMap<MemoryAddressCompareValue, DeleteValueObject>();
    }

    protected boolean isSavePathLimitContains(NavigateMetadata navigateMetadata, int deep) {
        if (this.savePathLimit.isEmpty()) {
            return true;
        }
        if (this.savePathLimit.size() > deep) {
            return this.savePathLimit.get(deep).contains(navigateMetadata.getPropertyName());
        }
        return false;
    }

    protected TargetValueTypeEnum getTargetValueType(EntityMetadata selfMetadata, NavigateMetadata navigateMetadata) {
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany) {
            boolean any;
            if (navigateMetadata.getMappingClass() != null && (any = this.selfPropsIsKeys(selfMetadata, navigateMetadata))) {
                return TargetValueTypeEnum.VALUE_OBJECT;
            }
            return TargetValueTypeEnum.RELATION_OTHER;
        }
        boolean selfIsKey = this.selfPropsIsKeys(selfMetadata, navigateMetadata);
        if (selfIsKey) {
            return TargetValueTypeEnum.VALUE_OBJECT;
        }
        boolean targetIsKey = this.targetPropsIsKeys(selfMetadata, navigateMetadata);
        if (targetIsKey) {
            return TargetValueTypeEnum.AGGREGATE_ROOT;
        }
        return TargetValueTypeEnum.RELATION_OTHER;
    }

    protected boolean selfPropsIsKeys(EntityMetadata selfMetadata, NavigateMetadata navigateMetadata) {
        Collection keyProperties;
        Object[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
        if (selfPropertiesOrPrimary.length != (keyProperties = selfMetadata.getKeyProperties()).size()) {
            return false;
        }
        return EasyArrayUtil.all((Object[])selfPropertiesOrPrimary, prop -> keyProperties.contains(prop));
    }

    protected boolean targetPropsIsKeys(EntityMetadata selfMetadata, NavigateMetadata navigateMetadata) {
        Collection keyProperties;
        Object[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
        if (targetPropertiesOrPrimary.length != (keyProperties = selfMetadata.getKeyProperties()).size()) {
            return false;
        }
        return EasyArrayUtil.all((Object[])targetPropertiesOrPrimary, prop -> keyProperties.contains(prop));
    }

    protected boolean targetAnyPropsIsKey(EntityMetadata selfMetadata, NavigateMetadata navigateMetadata) {
        Object[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
        Collection keyProperties = selfMetadata.getKeyProperties();
        return EasyArrayUtil.any((Object[])targetPropertiesOrPrimary, prop -> keyProperties.contains(prop));
    }

    protected void checkPrimaryKeyNotNull(EntityMetadata selfMetadata, Object entity, String error) {
        for (String keyProperty : selfMetadata.getKeyProperties()) {
            Object value = selfMetadata.getColumnNotNull(keyProperty).getGetterCaller().apply(entity);
            if (value != null) continue;
            throw new EasyQueryInvalidOperationException(error);
        }
    }

    protected void setTargetValue(TargetValueTypeEnum targetValueType, Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, EntityMetadata targetEntityMetadata) {
        if (targetValueType == TargetValueTypeEnum.VALUE_OBJECT) {
            String[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
            String[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
            for (int i = 0; i < selfPropertiesOrPrimary.length; ++i) {
                String self = selfPropertiesOrPrimary[i];
                String target = targetPropertiesOrPrimary[i];
                ColumnMetadata selfColumn = selfEntityMetadata.getColumnNotNull(self);
                Object selfValue = selfColumn.getGetterCaller().apply(selfEntity);
                if (selfValue == null) {
                    throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "] property:[" + self + "] value can not be null, cant set relation value for entity:[" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "]");
                }
                ColumnMetadata targetColumn = targetEntityMetadata.getColumnNotNull(target);
                Object currentValue = targetColumn.getGetterCaller().apply(targetEntity);
                if (currentValue == null || this.saveBehavior.hasBehavior(SaveBehaviorEnum.ALLOW_OWNERSHIP_CHANGE)) {
                    targetColumn.getSetterCaller().call(targetEntity, selfValue);
                    continue;
                }
                if (Objects.equals(currentValue, selfValue)) continue;
                throw new EasyQueryInvalidOperationException("relation value not equals,entity:[" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "],property:[" + target + "],value:[" + currentValue + "],should:[" + selfValue + "]. Current OwnershipPolicy does not allow reassignment.");
            }
        } else if (targetValueType == TargetValueTypeEnum.AGGREGATE_ROOT) {
            String[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
            String[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
            for (int i = 0; i < selfPropertiesOrPrimary.length; ++i) {
                String self = selfPropertiesOrPrimary[i];
                String target = targetPropertiesOrPrimary[i];
                ColumnMetadata targetColumn = targetEntityMetadata.getColumnNotNull(target);
                Object targetValue = targetColumn.getGetterCaller().apply(targetEntity);
                if (targetValue == null) {
                    throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "] property:[" + target + "] value can not be null, cant set relation value for entity:[" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "]");
                }
                ColumnMetadata selfColumn = selfEntityMetadata.getColumnNotNull(self);
                Object currentValue = selfColumn.getGetterCaller().apply(selfEntity);
                if (currentValue == null || this.saveBehavior.hasBehavior(SaveBehaviorEnum.ALLOW_OWNERSHIP_CHANGE)) {
                    selfColumn.getSetterCaller().call(selfEntity, targetValue);
                    continue;
                }
                if (Objects.equals(currentValue, targetValue)) continue;
                throw new EasyQueryInvalidOperationException("relation value not equals,entity:[" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "],property:[" + self + "],value:[" + currentValue + "],should:[" + targetValue + "]. Current OwnershipPolicy does not allow reassignment.");
            }
        } else {
            throw new EasyQueryInvalidOperationException("save not support target value type:" + (Object)((Object)targetValueType));
        }
    }

    protected void setTargetNullValue(TargetValueTypeEnum targetValueType, Object selfEntity, Object targetEntity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, EntityMetadata targetEntityMetadata) {
        if (targetValueType == TargetValueTypeEnum.VALUE_OBJECT) {
            String[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
            String[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
            for (int i = 0; i < selfPropertiesOrPrimary.length; ++i) {
                String target = targetPropertiesOrPrimary[i];
                ColumnMetadata targetColumn = targetEntityMetadata.getColumnNotNull(target);
                targetColumn.getSetterCaller().call(targetEntity, null);
            }
        } else if (targetValueType == TargetValueTypeEnum.AGGREGATE_ROOT) {
            String[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
            for (int i = 0; i < selfPropertiesOrPrimary.length; ++i) {
                String self = selfPropertiesOrPrimary[i];
                ColumnMetadata selfColumn = selfEntityMetadata.getColumnNotNull(self);
                selfColumn.getSetterCaller().call(selfEntity, null);
            }
        } else {
            throw new EasyQueryInvalidOperationException("save not support target value type:" + (Object)((Object)targetValueType));
        }
    }

    protected void setMappingEntity(Object selfEntity, Object targetEntity, Object mappingEntity, EntityMetadata selfEntityMetadata, NavigateMetadata navigateMetadata, EntityMetadata targetEntityMetadata, EntityMetadata mappingEntityMetadata) {
        String[] selfMappingProperties = navigateMetadata.getSelfMappingProperties();
        String[] selfPropertiesOrPrimary = navigateMetadata.getSelfPropertiesOrPrimary();
        for (int i = 0; i < selfMappingProperties.length; ++i) {
            String selfMappingProperty = selfMappingProperties[i];
            String self = selfPropertiesOrPrimary[i];
            ColumnMetadata selfColumn = selfEntityMetadata.getColumnNotNull(self);
            Object selfValue = selfColumn.getGetterCaller().apply(selfEntity);
            if (selfValue == null) {
                throw new EasyQueryInvalidOperationException("entityClass:[" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "] property:[" + self + "] value can not be null,Please make sure the [" + EasyClassUtil.getInstanceSimpleName((Object)selfEntity) + "] instance has been persisted to the database before use.");
            }
            ColumnMetadata columnMetadata = mappingEntityMetadata.getColumnNotNull(selfMappingProperty);
            columnMetadata.getSetterCaller().call(mappingEntity, selfValue);
        }
        String[] targetMappingProperties = navigateMetadata.getTargetMappingProperties();
        String[] targetPropertiesOrPrimary = navigateMetadata.getTargetPropertiesOrPrimary(this.runtimeContext);
        for (int i = 0; i < targetMappingProperties.length; ++i) {
            String targetMappingProperty = targetMappingProperties[i];
            String target = targetPropertiesOrPrimary[i];
            ColumnMetadata targetColumn = targetEntityMetadata.getColumnNotNull(target);
            Object targetValue = targetColumn.getGetterCaller().apply(targetEntity);
            if (targetValue == null) {
                throw new EasyQueryInvalidOperationException("entityClass:[" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "] property:[" + target + "] value can not be null,Please make sure the [" + EasyClassUtil.getInstanceSimpleName((Object)targetEntity) + "] instance has been persisted to the database before use.");
            }
            ColumnMetadata columnMetadata = mappingEntityMetadata.getColumnNotNull(targetMappingProperty);
            columnMetadata.getSetterCaller().call(mappingEntity, targetValue);
        }
    }

    protected EntityMetadata checkNavigateContinueAndGetTargetEntityMetadata(TargetValueTypeEnum targetValueType, NavigateMetadata navigateMetadata, int deep) {
        if (EasyCollectionUtil.isNotEmpty(this.savePathLimit)) {
            if (!this.isSavePathLimitContains(navigateMetadata, deep)) {
                return null;
            }
            if (targetValueType != TargetValueTypeEnum.VALUE_OBJECT) {
                throw new EasyQueryInvalidOperationException("entity:[" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getEntityMetadata().getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] value type is:[" + (Object)((Object)targetValueType) + "] save path limit only support value object");
            }
        }
        if (navigateMetadata.getRelationType() == RelationTypeEnum.ManyToMany && navigateMetadata.getMappingClass() != null) {
            return this.entityMetadataManager.getEntityMetadata(navigateMetadata.getMappingClass());
        }
        return this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
    }

    protected List<NavigateMetadata> getNavigateSavableValueObjects(EntityState entityState, SavableContext savableContext, Object entity, EntityMetadata entityMetadata, Collection<NavigateMetadata> navigateMetadataList, int deep) {
        ArrayList<NavigateMetadata> valueObjects = new ArrayList<NavigateMetadata>();
        ArrayList<NavigateMetadata> aggregateRoots = new ArrayList<NavigateMetadata>();
        HashSet navigateMetadataSet = new HashSet(entityMetadata.getNavigateMetadatas());
        for (NavigateMetadata navigateMetadata : navigateMetadataList) {
            navigateMetadataSet.remove(navigateMetadata);
            TargetValueTypeEnum targetValueType = this.getTargetValueType(entityMetadata, navigateMetadata);
            EntityMetadata targetEntityMetadata = this.checkNavigateContinueAndGetTargetEntityMetadata(targetValueType, navigateMetadata, deep);
            if (targetEntityMetadata == null || this.saveCommandContext.circulateCheck(navigateMetadata.getNavigatePropertyType(), deep)) continue;
            if (targetValueType == TargetValueTypeEnum.VALUE_OBJECT) {
                savableContext.putSaveNodeMap(navigateMetadata, targetEntityMetadata);
                valueObjects.add(navigateMetadata);
            }
            if (targetValueType != TargetValueTypeEnum.AGGREGATE_ROOT) continue;
            aggregateRoots.add(navigateMetadata);
        }
        for (NavigateMetadata navigateMetadata : aggregateRoots) {
            Property getter = navigateMetadata.getGetter();
            Object aggregateRoot = getter.apply(entity);
            EntityMetadata aggregateRootMetadata = this.entityMetadataManager.getEntityMetadata(navigateMetadata.getNavigatePropertyType());
            if (aggregateRoot != null) {
                this.setTargetValue(TargetValueTypeEnum.AGGREGATE_ROOT, entity, aggregateRoot, entityMetadata, navigateMetadata, aggregateRootMetadata);
                continue;
            }
            if (entityState == null || navigateMetadata.getCascade() == CascadeTypeEnum.NO_ACTION) continue;
            if (navigateMetadata.getCascade() == CascadeTypeEnum.DELETE) {
                throw new EasyQueryInvalidOperationException("The cascade of object [" + EasyClassUtil.getSimpleName((Class)entityMetadata.getEntityClass()) + "." + navigateMetadata.getPropertyName() + "] is set to delete. Detaching from the current aggregate root is not allowed; this operation must be initiated by the aggregate root object [" + EasyClassUtil.getSimpleName((Class)navigateMetadata.getNavigatePropertyType()) + "].");
            }
            if (navigateMetadata.getCascade() != CascadeTypeEnum.AUTO && navigateMetadata.getCascade() != CascadeTypeEnum.SET_NULL) continue;
            this.setTargetNullValue(TargetValueTypeEnum.AGGREGATE_ROOT, entity, null, entityMetadata, navigateMetadata, aggregateRootMetadata);
        }
        if (this.savePathLimit.isEmpty()) {
            for (NavigateMetadata navigateMetadata : navigateMetadataSet) {
                this.checkNavigatePathTrackedCheck(navigateMetadata, entity, entityMetadata);
            }
        }
        return valueObjects;
    }

    protected void checkNavigatePathTrackedCheck(NavigateMetadata navigate, Object entity, EntityMetadata selfEntityMetadata) {
        Object newEntity;
        Object newNavigateValue;
        Collection navigateValues;
        Property getter = navigate.getGetter();
        Object navigateValue = getter.apply(entity);
        if (navigateValue == null) {
            return;
        }
        if (navigateValue instanceof Collection && EasyCollectionUtil.isEmpty((Collection)(navigateValues = (Collection)navigateValue)) && (newNavigateValue = getter.apply(newEntity = selfEntityMetadata.getBeanConstructorCreator().get())) != null) {
            return;
        }
        throw new EasyQueryInvalidOperationException("The current navigation property [" + EasyClassUtil.getInstanceSimpleName((Object)entity) + "." + navigate.getPropertyName() + "] is not being tracked.");
    }
}

