/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.pgsql.types;

import com.easy.query.core.basic.jdbc.executor.internal.merge.result.StreamResultSet;
import com.easy.query.core.basic.jdbc.executor.internal.props.JdbcProperty;
import com.easy.query.core.basic.jdbc.parameter.SQLParameter;
import com.easy.query.core.basic.jdbc.types.EasyParameter;
import com.easy.query.core.basic.jdbc.types.handler.JdbcTypeHandler;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public class UUIDPgSQLTypeHandler
implements JdbcTypeHandler {
    public static final UUIDPgSQLTypeHandler INSTANCE = new UUIDPgSQLTypeHandler();

    public Object getValue(JdbcProperty jdbcProperty, StreamResultSet streamResultSet) throws SQLException {
        Object object = streamResultSet.getObject(jdbcProperty.getJdbcIndex());
        if (object instanceof String) {
            return UUID.fromString((String)object);
        }
        return object;
    }

    public void setParameter(EasyParameter parameter) throws SQLException {
        Object value = parameter.getValue();
        if (value == null) {
            parameter.getPs().setObject(parameter.getIndex(), null);
        } else {
            JDBCType jdbcType = this.getJdbcTType(parameter);
            if (jdbcType == JDBCType.VARCHAR) {
                parameter.getPs().setString(parameter.getIndex(), value.toString());
            } else {
                parameter.getPs().setObject(parameter.getIndex(), value, jdbcType.getVendorTypeNumber());
            }
        }
    }

    @NotNull
    private JDBCType getJdbcTType(EasyParameter parameter) {
        SQLParameter sqlParameter = parameter.getSQLParameter();
        if (sqlParameter != null) {
            return sqlParameter.getJdbcType();
        }
        return JDBCType.OTHER;
    }
}

