/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor.templates;

import java.util.HashMap;
import java.util.Map;

public class PropertyColumn {
    private final String sqlColumnName;
    private final String propertyType;
    private String navigateProxyName;
    private static Map<String, String> IMPORT_MAPPING = new HashMap<String, String>();

    public PropertyColumn(String sqlColumnName, String propertyType) {
        this.sqlColumnName = sqlColumnName;
        this.propertyType = propertyType;
    }

    public String getSqlColumnName() {
        return this.sqlColumnName;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public String getImport() {
        return IMPORT_MAPPING.get(this.sqlColumnName);
    }

    public String getSQLColumnMethod() {
        switch (this.sqlColumnName) {
            case "SQLNumberColumn": {
                return "getNumberColumn";
            }
            case "SQLBooleanColumn": {
                return "getBooleanColumn";
            }
            case "SQLStringColumn": {
                return "getStringColumn";
            }
            case "SQLDateTimeColumn": {
                return "getDateTimeColumn";
            }
            case "SQLAnyColumn": {
                return "getAnyColumn";
            }
        }
        return "get";
    }

    public String getNavigateProxyName() {
        return this.navigateProxyName;
    }

    public void setNavigateProxyName(String navigateProxyName) {
        this.navigateProxyName = navigateProxyName;
    }

    static {
        IMPORT_MAPPING.put("SQLNumberColumn", "com.easy.query.core.proxy.columns.SQLNumberColumn");
        IMPORT_MAPPING.put("SQLBooleanColumn", "com.easy.query.core.proxy.columns.SQLBooleanColumn");
        IMPORT_MAPPING.put("SQLStringColumn", "com.easy.query.core.proxy.columns.SQLStringColumn");
        IMPORT_MAPPING.put("SQLDateTimeColumn", "com.easy.query.core.proxy.columns.SQLDateTimeColumn");
        IMPORT_MAPPING.put("SQLAnyColumn", "com.easy.query.core.proxy.columns.SQLAnyColumn");
    }
}

