/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor;

import com.easy.query.core.annotation.ColumnIgnore;
import com.easy.query.core.annotation.EntityProxy;
import com.easy.query.core.util.EasyStringUtil;
import com.easy.query.processor.EasyQueryProxyProperties;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.easy.query.core.annotation.EntityProxy"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ProxyGenerateProcessor
extends AbstractProcessor {
    private static final Map<String, String> TYPE_MAPPING = new HashMap<String, String>();
    private static final String PROXY_TEMPLATE = "package @package;\n\nimport com.easy.query.core.expression.parser.core.available.TableAvailable;\nimport com.easy.query.core.proxy.AbstractProxyEntity;\nimport com.easy.query.core.proxy.SQLColumn;\nimport @entityFullClass;\n\n/**\n * this file automatically generated by easy-query, don't modify it\n *\n * @author xuejiaming\n */\npublic class @entityClassProxy extends AbstractProxyEntity<@entityClassProxy, @entityClass> {\n\n    private static final Class<@entityClass> entityClass = @entityClass.class;\n    public static @entityClassProxy createTable() {\n        return new @entityClassProxy();\n    }\n\n    private @entityClassProxy() {\n    }\n\n    @fieldContent\n    @Override\n    public Class<@entityClass> getEntityClass() {\n        return entityClass;\n    }\n\n}";
    private static final String FIELD_TEMPLATE = "\n    @comment\n    public SQLColumn<@entityClassProxy,@propertyType> @property(){\n        return get(\"@property\");\n    }";
    private static final String FIELD_DOC_COMMENT_TEMPLATE = "\n    /**\n     * {@link @entityClass#@property}\n     @comment\n     */";
    private static final String FIELD_EMPTY_DOC_COMMENT_TEMPLATE = "\n    /**\n     * {@link @entityClass#@property}\n     */";
    private Filer filer;
    private Elements elementUtils;
    private Types typeUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            EasyQueryProxyProperties props = new EasyQueryProxyProperties(this.filer);
            String enable = props.getProperties().getProperty("processor.enable", "");
            if ("false".equalsIgnoreCase(enable)) {
                return true;
            }
            String basePath = props.getProperties().getProperty("processor.basePath", "");
            String proxyClassSuffix = props.getProperties().getProperty("processor.proxyClassSuffix", "Proxy");
            String defaultProxyInstanceName = props.getProperties().getProperty("processor.proxyInstanceName", "DEFAULT");
            String[] entityIgnoreSuffixes = props.getProperties().getProperty("processor.entity.ignoreSuffixes", "").split(",");
            AtomicReference entityClassNameReference = new AtomicReference();
            roundEnv.getElementsAnnotatedWith(EntityProxy.class).forEach(entityClassElement -> {
                String proxyInstanceName;
                String proxyEntityName = entityClassElement.getSimpleName().toString();
                for (String entityIgnoreSuffix : entityIgnoreSuffixes) {
                    if (!proxyEntityName.endsWith(entityIgnoreSuffix.trim())) continue;
                    proxyEntityName = proxyEntityName.substring(0, proxyEntityName.length() - entityIgnoreSuffix.length());
                    break;
                }
                EntityProxy entityProxy = entityClassElement.getAnnotation(EntityProxy.class);
                entityClassNameReference.set(entityClassElement.toString());
                String string = proxyInstanceName = EasyStringUtil.isBlank((String)entityProxy.value()) ? defaultProxyInstanceName : entityProxy.value();
                if (EasyStringUtil.isBlank((String)proxyInstanceName)) {
                    proxyInstanceName = ProxyGenerateProcessor.buildName(entityClassNameReference + "Proxy", "upperCase");
                }
                HashSet<String> ignoreProperties = new HashSet<String>(Arrays.asList(entityProxy.ignoreProperties()));
                String entityFullName = (String)entityClassNameReference.get();
                String realGenPackage = this.guessTablesPackage(entityFullName);
                String entityClassName = entityClassElement.getSimpleName().toString();
                StringBuilder fieldContent = new StringBuilder();
                TypeElement classElement = (TypeElement)entityClassElement;
                do {
                    this.fillPropertyAndColumns(fieldContent, entityClassName, classElement, ignoreProperties);
                } while ((classElement = (TypeElement)this.typeUtils.asElement(classElement.getSuperclass())) != null);
                String content = this.buildTablesClass(entityClassName, proxyInstanceName, realGenPackage, entityFullName, fieldContent.toString());
                this.genClass(basePath, realGenPackage, proxyEntityName + proxyClassSuffix, content);
            });
        }
        return false;
    }

    public boolean isAbsolutePath(String path) {
        return path != null && (path.startsWith("/") || path.indexOf(":") > 0);
    }

    private String getProjectRootPath(String genFilePath) {
        File file = new File(genFilePath);
        int count = 20;
        return this.getProjectRootPath(file, count);
    }

    private String getProjectRootPath(File file, int count) {
        if (count <= 0) {
            return null;
        }
        if (file.isFile()) {
            return this.getProjectRootPath(file.getParentFile(), --count);
        }
        if (new File(file, "pom.xml").exists() && !new File(file.getParentFile(), "pom.xml").exists()) {
            return file.getAbsolutePath();
        }
        return this.getProjectRootPath(file.getParentFile(), --count);
    }

    private boolean isFromTestSource(String path) {
        return path.contains("test-sources") || path.contains("test-annotations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genClass(String basePath, String genPackageName, String className, String genContent) {
        Writer writer = null;
        try {
            String realPath;
            JavaFileObject sourceFile = this.filer.createSourceFile(genPackageName + "." + className, new Element[0]);
            if (basePath == null || basePath.trim().length() == 0) {
                writer = sourceFile.openWriter();
                writer.write(genContent);
                writer.flush();
                return;
            }
            String defaultGenPath = sourceFile.toUri().getPath();
            if (this.isAbsolutePath(basePath)) {
                realPath = basePath;
            } else {
                String projectRootPath = this.getProjectRootPath(defaultGenPath);
                realPath = new File(projectRootPath, basePath).getAbsolutePath();
            }
            boolean fromTestSource = this.isFromTestSource(defaultGenPath);
            realPath = fromTestSource ? new File(realPath, "src/test/java").getAbsolutePath() : new File(realPath, "src/main/java").getAbsolutePath();
            File genJavaFile = new File(realPath, (genPackageName + "." + className).replace(".", "/") + ".java");
            if (!genJavaFile.getParentFile().exists() && !genJavaFile.getParentFile().mkdirs()) {
                System.out.println(">>>>>ERROR: can not mkdirs by easy-query processor for: " + genJavaFile.getParentFile());
                return;
            }
            writer = new PrintWriter(new FileOutputStream(genJavaFile));
            writer.write(genContent);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String camelToUnderline(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String firstCharToUpperCase(String string) {
        char firstChar = string.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = string.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return string;
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    private static String buildName(String name, String style) {
        if ("upperCase".equalsIgnoreCase(style)) {
            return ProxyGenerateProcessor.camelToUnderline(name).toUpperCase();
        }
        if ("lowerCase".equalsIgnoreCase(style)) {
            return ProxyGenerateProcessor.camelToUnderline(name).toLowerCase();
        }
        if ("upperCamelCase".equalsIgnoreCase(style)) {
            return ProxyGenerateProcessor.firstCharToUpperCase(name);
        }
        return ProxyGenerateProcessor.firstCharToLowerCase(name);
    }

    private String buildTablesClass(String entityClass, String proxyInstanceName, String realGenPackage, String entityFullName, String fieldContent) {
        String tableDef = PROXY_TEMPLATE.replace("@package", realGenPackage).replace("@entityFullClass", entityFullName).replace("@proxyInstanceName", proxyInstanceName).replace("@fieldContent", fieldContent).replace("@entityClass", entityClass);
        return tableDef;
    }

    private String guessTablesPackage(String entityClassName) {
        StringBuilder guessPackage = new StringBuilder();
        if (!entityClassName.contains(".")) {
            guessPackage.append("proxy");
        } else {
            guessPackage.append(entityClassName, 0, entityClassName.lastIndexOf(".")).append(".proxy");
        }
        return guessPackage.toString();
    }

    private void fillPropertyAndColumns(StringBuilder filedContent, String entityClass, TypeElement classElement, Set<String> ignoreProperties) {
        for (Element element : classElement.getEnclosedElements()) {
            ColumnIgnore column;
            String propertyName;
            Set<Modifier> modifiers;
            if (ElementKind.FIELD != element.getKind() || (modifiers = element.getModifiers()).contains((Object)Modifier.STATIC) || ignoreProperties.contains(propertyName = element.toString()) || (column = element.getAnnotation(ColumnIgnore.class)) != null) continue;
            TypeMirror type = element.asType();
            boolean isGeneric = type.getKind() == TypeKind.TYPEVAR;
            String fieldGenericType = this.getGenericTypeString(isGeneric, type);
            String docComment = this.elementUtils.getDocComment(element);
            String fieldComment = this.getFiledComment(docComment);
            String fieldString = FIELD_TEMPLATE.replace("@entityClass", entityClass).replace("@comment", fieldComment).replace("@propertyType", fieldGenericType).replace("@property", propertyName);
            filedContent.append(fieldString);
        }
    }

    private String getFiledComment(String docComment) {
        if (docComment == null) {
            return FIELD_EMPTY_DOC_COMMENT_TEMPLATE;
        }
        String[] commentLines = docComment.trim().split("\n");
        StringBuilder fieldComment = new StringBuilder();
        fieldComment.append("* ").append(commentLines[0]);
        for (int i = 1; i < commentLines.length; ++i) {
            fieldComment.append("\n     *").append(commentLines[i]);
        }
        return FIELD_DOC_COMMENT_TEMPLATE.replace("@comment", fieldComment.toString());
    }

    private String getGenericTypeString(boolean isGeneric, TypeMirror type) {
        if (isGeneric) {
            return "java.lang.Object";
        }
        String typeString = type.toString();
        return TYPE_MAPPING.getOrDefault(typeString, typeString);
    }

    static {
        TYPE_MAPPING.put("float", "java.lang.Float");
        TYPE_MAPPING.put("double", "java.lang.Double");
        TYPE_MAPPING.put("short", "java.lang.Short");
        TYPE_MAPPING.put("int", "java.lang.Integer");
        TYPE_MAPPING.put("long", "java.lang.Long");
        TYPE_MAPPING.put("byte", "java.lang.Byte");
        TYPE_MAPPING.put("boolean", "java.lang.Boolean");
    }
}

