/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor.templates;

import com.easy.query.processor.templates.AptFileCompiler;
import com.easy.query.processor.templates.AptPropertyInfo;
import com.easy.query.processor.templates.AptSelectPropertyInfo;
import com.easy.query.processor.templates.AptSelectorInfo;
import com.easy.query.processor.templates.AptValueObjectInfo;

public class AptCreatorHelper {
    public static String createProxy(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        String selectorContent = AptCreatorHelper.renderSelectorUI(aptFileCompiler);
        String propertyContent = AptCreatorHelper.renderPropertyUI(aptFileCompiler, aptValueObjectInfo);
        String valueObjectContent = AptCreatorHelper.renderValueObjectUI(aptFileCompiler, aptValueObjectInfo);
        String proxyTemplate = "package @{package};\n\nimport com.easy.query.core.expression.parser.core.available.TableAvailable;\nimport com.easy.query.core.proxy.AbstractProxyEntity;\nimport com.easy.query.core.proxy.SQLColumn;\n@{imports}\n/**\n * this file automatically generated by easy-query, don't modify it\n *\n * @author xuejiaming\n */\npublic class @{entityClassProxy} extends AbstractProxyEntity<@{entityClassProxy}, @{entityClass}> {\n\n    private static final Class<@{entityClass}> entityClass = @{entityClass}.class;\n    public static @{entityClassProxy} createTable() {\n        return new @{entityClassProxy}();\n    }\n\n    public @{entityClassProxy}() {\n    }\n\n    @{fieldContent}\n    @Override\n    public Class<@{entityClass}> getEntityClass() {\n        return entityClass;\n    }\n\n    @{valueObjectContext}\n\n    @{selectorContext}\n\n}".replace("@{package}", aptFileCompiler.getPackageName()).replace("@{imports}", String.join((CharSequence)"\n", aptFileCompiler.getImports())).replace("@{entityClass}", aptFileCompiler.getEntityClassName()).replace("@{entityClassProxy}", aptFileCompiler.getEntityClassProxyName()).replace("@{fieldContent}", propertyContent).replace("@{valueObjectContext}", valueObjectContent).replace("@{selectorContext}", selectorContent);
        return proxyTemplate;
    }

    private static String renderPropertyUI(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        StringBuilder filedContent = new StringBuilder();
        for (AptPropertyInfo property : aptValueObjectInfo.getProperties()) {
            String fieldString;
            if (property.isValueObject()) {
                fieldString = "\n    @{comment}\n    public @{entityClass}Proxy @{property}() {\n        return getValueObject(new @{entityClass}Proxy(getTable(), getValueProperty(\"@{property}\")));\n    }".replace("@{entityClass}", property.getEntityName()).replace("@{comment}", property.getComment()).replace("@{propertyType}", property.getPropertyType()).replace("@{property}", property.getPropertyName());
                filedContent.append(fieldString);
                continue;
            }
            fieldString = "\n    @{comment}\n    public SQLColumn<@{entityClassProxy},@{propertyType}> @{property}(){\n        return get(\"@{property}\");\n    }".replace("@{entityClassProxy}", aptFileCompiler.getEntityClassProxyName()).replace("@{comment}", property.getComment()).replace("@{propertyType}", property.getPropertyType()).replace("@{property}", property.getPropertyName());
            filedContent.append(fieldString);
        }
        return filedContent.toString();
    }

    private static String renderSelectorUI(AptFileCompiler aptFileCompiler) {
        String fieldSelectorContent = AptCreatorHelper.renderSelectorPropertyUI(aptFileCompiler);
        AptSelectorInfo selectorInfo = aptFileCompiler.getSelectorInfo();
        return "\n/**\n* \u6570\u636e\u5e93\u5217\u7684\u7b80\u5355\u83b7\u53d6\n* @return\n*/\npublic @{selectorName} cols() {\n        return new @{selectorName}(this);\n    }\n\n    public static class @{selectorName} extends AbstractSelector<@{entityClassProxy},@{entityClass}, @{selectorName}> {\n\n        public @{selectorName}(@{entityClassProxy} proxy) {\n            super(proxy);\n        }\n\n        @{fieldSelectorContent}\n    }".replace("@{entityClass}", aptFileCompiler.getEntityClassName()).replace("@{selectorName}", selectorInfo.getName()).replace("@{entityClassProxy}", aptFileCompiler.getEntityClassProxyName()).replace("@{fieldSelectorContent}", fieldSelectorContent);
    }

    private static String renderSelectorPropertyUI(AptFileCompiler aptFileCompiler) {
        AptSelectorInfo selectorInfo = aptFileCompiler.getSelectorInfo();
        StringBuilder filedContent = new StringBuilder();
        for (AptSelectPropertyInfo property : selectorInfo.getProperties()) {
            String fieldString = "\n    @{comment}\n    public @{selectorName} @{property}() {\n            return add(getProxy().@{property}());\n    }".replace("@{selectorName}", selectorInfo.getName()).replace("@{comment}", property.getComment()).replace("@{property}", property.getPropertyName());
            filedContent.append(fieldString);
        }
        return filedContent.toString();
    }

    private static String renderValueObjectUI(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        StringBuilder valueObjectContentBuilder = new StringBuilder();
        for (AptValueObjectInfo valueObject : aptValueObjectInfo.getChildren()) {
            String propertyContent = AptCreatorHelper.renderPropertyUI(aptFileCompiler, valueObject);
            String vc = AptCreatorHelper.renderValueObjectUI(aptFileCompiler, valueObject);
            String valueObjectContent = "\n    public static class @{entityClass}Proxy extends AbstractValueObjectProxyEntity<@{mainEntityClassProxy}, @{entityClass}> {\n\n        private @{entityClass}Proxy(TableAvailable table, String propertyName) {\n            super(table, propertyName);\n        }\n\n        @{fieldContent}\n        @{valueObjectContext}    }".replace("@{entityClass}", valueObject.getEntityName()).replace("@{mainEntityClassProxy}", aptFileCompiler.getEntityClassProxyName()).replace("@{fieldContent}", propertyContent).replace("@{valueObjectContext}", vc);
            valueObjectContentBuilder.append(valueObjectContent);
            valueObjectContentBuilder.append("\n");
        }
        return valueObjectContentBuilder.toString();
    }
}

