/*
 * Decompiled with CFR 0.152.
 */
package com.easy.query.processor;

import com.easy.query.core.annotation.ColumnIgnore;
import com.easy.query.core.annotation.EntityProxy;
import com.easy.query.core.annotation.Navigate;
import com.easy.query.core.annotation.ValueObject;
import com.easy.query.core.util.EasyStringUtil;
import com.easy.query.processor.EasyQueryProxyProperties;
import com.easy.query.processor.templates.AptCreatorHelper;
import com.easy.query.processor.templates.AptFileCompiler;
import com.easy.query.processor.templates.AptPropertyInfo;
import com.easy.query.processor.templates.AptValueObjectInfo;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.JavaFileObject;

@SupportedAnnotationTypes(value={"com.easy.query.core.annotation.EntityProxy"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
public class ProxyGenerateProcessor
extends AbstractProcessor {
    private static final Map<String, String> TYPE_MAPPING = new HashMap<String, String>();
    private static final String FIELD_DOC_COMMENT_TEMPLATE = "\n    /**\n     * {@link @{entityClass}#@{property}}\n     @{comment}\n     */";
    private static final String FIELD_EMPTY_DOC_COMMENT_TEMPLATE = "\n    /**\n     * {@link @{entityClass}#@{property}}\n     */";
    private Filer filer;
    private Elements elementUtils;
    private Types typeUtils;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (!roundEnv.processingOver()) {
            EasyQueryProxyProperties props = new EasyQueryProxyProperties(this.filer);
            String enable = props.getProperties().getProperty("processor.enable", "");
            if ("false".equalsIgnoreCase(enable)) {
                return true;
            }
            String basePath = props.getProperties().getProperty("processor.basePath", "");
            AtomicReference entityClassNameReference = new AtomicReference();
            roundEnv.getElementsAnnotatedWith(EntityProxy.class).forEach(entityClassElement -> {
                EntityProxy entityProxy = entityClassElement.getAnnotation(EntityProxy.class);
                entityClassNameReference.set(entityClassElement.toString());
                String entityFullName = (String)entityClassNameReference.get();
                String realGenPackage = this.guessTablesPackage(entityFullName);
                String entityClassName = entityClassElement.getSimpleName().toString();
                String proxyInstanceName = EasyStringUtil.isBlank((String)entityProxy.value()) ? entityClassName + "Proxy" : entityProxy.value();
                HashSet<String> ignoreProperties = new HashSet<String>(Arrays.asList(entityProxy.ignoreProperties()));
                TypeElement classElement = (TypeElement)entityClassElement;
                AptFileCompiler aptFileCompiler = new AptFileCompiler(realGenPackage, entityClassName, proxyInstanceName);
                AptValueObjectInfo aptValueObjectInfo = new AptValueObjectInfo(entityClassName);
                aptFileCompiler.addImports(entityFullName);
                do {
                    this.fillPropertyAndColumns(aptFileCompiler, aptValueObjectInfo, classElement, ignoreProperties);
                } while ((classElement = (TypeElement)this.typeUtils.asElement(classElement.getSuperclass())) != null);
                String content = this.buildTablesClass(aptFileCompiler, aptValueObjectInfo);
                this.genClass(basePath, realGenPackage, proxyInstanceName, content);
            });
        }
        return false;
    }

    public boolean isAbsolutePath(String path) {
        return path != null && (path.startsWith("/") || path.indexOf(":") > 0);
    }

    private String getProjectRootPath(String genFilePath) {
        File file = new File(genFilePath);
        int count = 20;
        return this.getProjectRootPath(file, count);
    }

    private String getProjectRootPath(File file, int count) {
        if (count <= 0) {
            return null;
        }
        if (file.isFile()) {
            return this.getProjectRootPath(file.getParentFile(), --count);
        }
        if (new File(file, "pom.xml").exists() && !new File(file.getParentFile(), "pom.xml").exists()) {
            return file.getAbsolutePath();
        }
        return this.getProjectRootPath(file.getParentFile(), --count);
    }

    private boolean isFromTestSource(String path) {
        return path.contains("test-sources") || path.contains("test-annotations");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genClass(String basePath, String genPackageName, String className, String genContent) {
        Writer writer = null;
        try {
            String realPath;
            JavaFileObject sourceFile = this.filer.createSourceFile(genPackageName + "." + className, new Element[0]);
            if (basePath == null || basePath.trim().length() == 0) {
                writer = sourceFile.openWriter();
                writer.write(genContent);
                writer.flush();
                return;
            }
            String defaultGenPath = sourceFile.toUri().getPath();
            if (this.isAbsolutePath(basePath)) {
                realPath = basePath;
            } else {
                String projectRootPath = this.getProjectRootPath(defaultGenPath);
                realPath = new File(projectRootPath, basePath).getAbsolutePath();
            }
            boolean fromTestSource = this.isFromTestSource(defaultGenPath);
            realPath = fromTestSource ? new File(realPath, "src/test/java").getAbsolutePath() : new File(realPath, "src/main/java").getAbsolutePath();
            File genJavaFile = new File(realPath, (genPackageName + "." + className).replace(".", "/") + ".java");
            if (!genJavaFile.getParentFile().exists() && !genJavaFile.getParentFile().mkdirs()) {
                System.out.println(">>>>>ERROR: can not mkdirs by easy-query processor for: " + genJavaFile.getParentFile());
                return;
            }
            writer = new PrintWriter(new FileOutputStream(genJavaFile));
            writer.write(genContent);
            writer.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static String camelToUnderline(String string) {
        if (string == null || string.trim().length() == 0) {
            return "";
        }
        int len = string.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (Character.isUpperCase(c) && i > 0) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static String firstCharToUpperCase(String string) {
        char firstChar = string.charAt(0);
        if (firstChar >= 'a' && firstChar <= 'z') {
            char[] arr = string.toCharArray();
            arr[0] = (char)(arr[0] - 32);
            return new String(arr);
        }
        return string;
    }

    public static String firstCharToLowerCase(String str) {
        char firstChar = str.charAt(0);
        if (firstChar >= 'A' && firstChar <= 'Z') {
            char[] arr = str.toCharArray();
            arr[0] = (char)(arr[0] + 32);
            return new String(arr);
        }
        return str;
    }

    private static String buildName(String name, String style) {
        if ("upperCase".equalsIgnoreCase(style)) {
            return ProxyGenerateProcessor.camelToUnderline(name).toUpperCase();
        }
        if ("lowerCase".equalsIgnoreCase(style)) {
            return ProxyGenerateProcessor.camelToUnderline(name).toLowerCase();
        }
        if ("upperCamelCase".equalsIgnoreCase(style)) {
            return ProxyGenerateProcessor.firstCharToUpperCase(name);
        }
        return ProxyGenerateProcessor.firstCharToLowerCase(name);
    }

    private String buildTablesClass(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo) {
        return AptCreatorHelper.createProxy(aptFileCompiler, aptValueObjectInfo);
    }

    private String guessTablesPackage(String entityClassName) {
        StringBuilder guessPackage = new StringBuilder();
        if (!entityClassName.contains(".")) {
            guessPackage.append("proxy");
        } else {
            guessPackage.append(entityClassName, 0, entityClassName.lastIndexOf(".")).append(".proxy");
        }
        return guessPackage.toString();
    }

    private void fillValueObject(String parentProperty, AptValueObjectInfo aptValueObjectInfo, Element fieldClassElement, AptFileCompiler aptFileCompiler, Set<String> ignoreProperties) {
        String entityName = aptValueObjectInfo.getEntityName();
        for (Element element : fieldClassElement.getEnclosedElements()) {
            ColumnIgnore column;
            Set<Modifier> modifiers;
            if (ElementKind.FIELD != element.getKind() || (modifiers = element.getModifiers()).contains((Object)Modifier.STATIC)) continue;
            String propertyName = element.toString();
            if (!ignoreProperties.isEmpty() && ignoreProperties.contains(parentProperty + "." + propertyName) || (column = element.getAnnotation(ColumnIgnore.class)) != null) continue;
            Navigate navigate = element.getAnnotation(Navigate.class);
            boolean includeProperty = navigate != null;
            TypeMirror type = element.asType();
            boolean isGeneric = type.getKind() == TypeKind.TYPEVAR;
            boolean isDeclared = type.getKind() == TypeKind.DECLARED;
            String fieldGenericType = this.getGenericTypeString(isGeneric, isDeclared, includeProperty, type);
            String docComment = this.elementUtils.getDocComment(element);
            ValueObject valueObject = element.getAnnotation(ValueObject.class);
            boolean isValueObject = valueObject != null;
            String fieldName = isValueObject ? fieldGenericType.substring(fieldGenericType.lastIndexOf(".") + 1) : entityName;
            String fieldComment = this.getFiledComment(docComment, fieldName, propertyName);
            aptValueObjectInfo.getProperties().add(new AptPropertyInfo(propertyName, fieldGenericType, fieldComment, fieldName, isValueObject));
            if (valueObject == null) continue;
            aptFileCompiler.addImports(fieldGenericType);
            String valueObjectClassName = fieldGenericType.substring(fieldGenericType.lastIndexOf(".") + 1);
            Element fieldClass = ((DeclaredType)type).asElement();
            AptValueObjectInfo fieldAptValueObjectInfo = new AptValueObjectInfo(valueObjectClassName);
            aptValueObjectInfo.getChildren().add(fieldAptValueObjectInfo);
            this.fillValueObject(parentProperty + "." + propertyName, fieldAptValueObjectInfo, fieldClass, aptFileCompiler, ignoreProperties);
        }
    }

    private void fillPropertyAndColumns(AptFileCompiler aptFileCompiler, AptValueObjectInfo aptValueObjectInfo, TypeElement classElement, Set<String> ignoreProperties) {
        for (Element element : classElement.getEnclosedElements()) {
            ColumnIgnore column;
            Set<Modifier> modifiers;
            if (ElementKind.FIELD != element.getKind() || (modifiers = element.getModifiers()).contains((Object)Modifier.STATIC)) continue;
            String propertyName = element.toString();
            if (!ignoreProperties.isEmpty() && ignoreProperties.contains(propertyName) || (column = element.getAnnotation(ColumnIgnore.class)) != null) continue;
            Navigate navigate = element.getAnnotation(Navigate.class);
            boolean includeProperty = navigate != null;
            TypeMirror type = element.asType();
            boolean isGeneric = type.getKind() == TypeKind.TYPEVAR;
            boolean isDeclared = type.getKind() == TypeKind.DECLARED;
            String fieldGenericType = this.getGenericTypeString(isGeneric, isDeclared, includeProperty, type);
            String docComment = this.elementUtils.getDocComment(element);
            ValueObject valueObject = element.getAnnotation(ValueObject.class);
            boolean isValueObject = valueObject != null;
            String fieldName = isValueObject ? fieldGenericType.substring(fieldGenericType.lastIndexOf(".") + 1) : aptFileCompiler.getEntityClassName();
            String fieldComment = this.getFiledComment(docComment, fieldName, propertyName);
            aptValueObjectInfo.getProperties().add(new AptPropertyInfo(propertyName, fieldGenericType, fieldComment, fieldName, isValueObject));
            if (valueObject == null) continue;
            aptFileCompiler.addImports("com.easy.query.core.proxy.AbstractValueObjectProxyEntity");
            aptFileCompiler.addImports(fieldGenericType);
            String valueObjectClassName = fieldGenericType.substring(fieldGenericType.lastIndexOf(".") + 1);
            Element fieldClass = ((DeclaredType)type).asElement();
            AptValueObjectInfo fieldAptValueObjectInfo = new AptValueObjectInfo(valueObjectClassName);
            aptValueObjectInfo.getChildren().add(fieldAptValueObjectInfo);
            this.fillValueObject(propertyName, fieldAptValueObjectInfo, fieldClass, aptFileCompiler, ignoreProperties);
        }
    }

    private String getFiledComment(String docComment, String className, String propertyName) {
        if (docComment == null) {
            return FIELD_EMPTY_DOC_COMMENT_TEMPLATE.replace("@{entityClass}", className).replace("@{property}", propertyName);
        }
        String[] commentLines = docComment.trim().split("\n");
        StringBuilder fieldComment = new StringBuilder();
        fieldComment.append("* ").append(commentLines[0]);
        for (int i = 1; i < commentLines.length; ++i) {
            fieldComment.append("\n     *").append(commentLines[i]);
        }
        return FIELD_DOC_COMMENT_TEMPLATE.replace("@{comment}", fieldComment.toString()).replace("@{entityClass}", className).replace("@{property}", propertyName);
    }

    private String getGenericTypeString(boolean isGeneric, boolean isDeclared, boolean includeProperty, TypeMirror type) {
        if (isGeneric) {
            return "java.lang.Object";
        }
        String typeString = this.defTypeString(isDeclared, includeProperty, type);
        return TYPE_MAPPING.getOrDefault(typeString, typeString);
    }

    private String defTypeString(boolean isDeclared, boolean includeProperty, TypeMirror type) {
        if (includeProperty || !isDeclared) {
            return type.toString().trim();
        }
        Element element = this.typeUtils.asElement(type);
        if (element != null) {
            return element.asType().toString().trim();
        }
        return type.toString().trim();
    }

    static {
        TYPE_MAPPING.put("float", "java.lang.Float");
        TYPE_MAPPING.put("double", "java.lang.Double");
        TYPE_MAPPING.put("short", "java.lang.Short");
        TYPE_MAPPING.put("int", "java.lang.Integer");
        TYPE_MAPPING.put("long", "java.lang.Long");
        TYPE_MAPPING.put("byte", "java.lang.Byte");
        TYPE_MAPPING.put("boolean", "java.lang.Boolean");
    }
}

