/*
 * Decompiled with CFR 0.152.
 */
package com.eccyan.optional;

import java.util.Collections;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.internal.operators.OnSubscribeFromIterable;

public class Optional<T>
extends Observable<T> {
    public static <U> Optional<U> of(U data) {
        if (data == null) {
            throw new NullPointerException();
        }
        return new Optional<U>(new OnSubscribeForSingleItem<U>(data));
    }

    public static <U> Optional<U> ofNullable(U data) {
        if (data == null) {
            return new Optional(new OnSubscribeFromIterable(Collections.emptyList()));
        }
        return Optional.of(data);
    }

    protected Optional(Observable.OnSubscribe<T> f) {
        super(f);
    }

    public boolean isPresent() {
        return (Boolean)this.isEmpty().toBlocking().single();
    }

    public void ifPresent(Action1<? super T> action) {
        this.subscribe(action);
    }

    public T get() {
        return (T)this.toBlocking().single();
    }

    public T orElse(T other) {
        return (T)this.defaultIfEmpty(other).toBlocking().single();
    }

    public T orElseCall(Func0<? extends T> other) {
        return (T)(this.isPresent() ? this.get() : other.call());
    }

    public <X extends Throwable> T orElseThrow(Func0<? extends X> other) throws X {
        if (!this.isPresent()) {
            throw (Throwable)other.call();
        }
        return this.get();
    }

    public static class OnSubscribeForSingleItem<T>
    implements Observable.OnSubscribe<T> {
        private final T item;

        public OnSubscribeForSingleItem(T item) {
            this.item = item;
        }

        public void call(Subscriber<? super T> subscriber) {
            subscriber.onNext(this.item);
            subscriber.onCompleted();
        }
    }
}

