/*
 * Decompiled with CFR 0.152.
 */
package com.eccyan.optional;

import java.util.Collections;
import java.util.Objects;
import rx.Observable;
import rx.Subscriber;
import rx.functions.Action1;
import rx.functions.Func0;
import rx.functions.Func1;
import rx.internal.operators.OnSubscribeFromIterable;

public class Optional<T>
extends Observable<T> {
    public static <U> Optional<U> of(U data) {
        if (data == null) {
            throw new NullPointerException();
        }
        return new Optional<U>(new OnSubscribeForSingleItem<U>(data));
    }

    public static <U> Optional<U> ofNullable(U data) {
        if (data == null) {
            return Optional.optionalEmpty();
        }
        return Optional.of(data);
    }

    public static <U> Optional<U> optionalEmpty() {
        return new Optional(new OnSubscribeFromIterable(Collections.emptyList()));
    }

    protected Optional(Observable.OnSubscribe<T> f) {
        super(f);
    }

    public boolean isPresent() {
        return (Boolean)this.isEmpty().toBlocking().single() == false;
    }

    public void ifPresent(Action1<? super T> action) {
        this.subscribe(action);
    }

    public T get() {
        return (T)this.toBlocking().single();
    }

    public T orElse(T other) {
        return (T)this.defaultIfEmpty(other).toBlocking().single();
    }

    public T orElseCall(Func0<? extends T> other) {
        return (T)(this.isPresent() ? this.get() : other.call());
    }

    public <X extends Throwable> T orElseThrow(Func0<? extends X> other) throws X {
        if (!this.isPresent()) {
            throw (Throwable)other.call();
        }
        return this.get();
    }

    public Optional<T> filter(final Predicate<T> predicate) {
        Objects.requireNonNull(predicate);
        return Optional.ofNullable(this.filter(new Func1<T, Boolean>(){

            public Boolean call(T t) {
                return (Boolean)predicate.call(t);
            }
        }).toBlocking().singleOrDefault(null));
    }

    public <U> Optional<U> map(final Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        return Optional.ofNullable(this.map(new Func1<T, U>(){

            public U call(T t) {
                return mapper.call(t);
            }
        }).toBlocking().singleOrDefault(null));
    }

    public <U> Optional<U> flatMap(final Function<? super T, Optional<U>> mapper) {
        Objects.requireNonNull(mapper);
        return Optional.ofNullable(this.flatMap(new Func1<T, Optional<U>>(){

            public Optional<U> call(T t) {
                return (Optional)((Object)Objects.requireNonNull(mapper.call(t)));
            }
        }).toBlocking().singleOrDefault(null));
    }

    public static class OnSubscribeForSingleItem<T>
    implements Observable.OnSubscribe<T> {
        private final T item;

        public OnSubscribeForSingleItem(T item) {
            this.item = item;
        }

        public void call(Subscriber<? super T> subscriber) {
            subscriber.onNext(this.item);
            subscriber.onCompleted();
        }
    }

    public static abstract class Function<T, U>
    implements Func1<T, U> {
    }

    public static abstract class Predicate<T>
    implements Func1<T, Boolean> {
    }
}

