package com.eventstore.dbclient;

import java.util.UUID;

class AccountCreated {
    private UUID id;
    private String login;

    public UUID getId() {
        return id;
    }

    public String getLogin() {
        return login;
    }

    public void setId(UUID id) {
        this.id = id;
    }

    public void setLogin(String login) {
        this.login = login;
    }
}

public class Main {
    public static void main(String args[]) throws Exception {
        EventStoreDBConnection connection = Connections.builder()
                .createSingleNodeConnection("localhost", 2113);

        Streams streamsAPI = Streams.create(connection);

        AccountCreated createdEvent = new AccountCreated();

        createdEvent.setId(UUID.randomUUID());
        createdEvent.setLogin("ouros");

        ProposedEvent event = ProposedEvent
                .builderAsJson("account-created", createdEvent)
                .build();

        WriteResult writeResult = streamsAPI.appendStream("accounts")
                .addEvent(event)
                .execute()
                .get();

        ResolvedEvent resolvedEvent = streamsAPI.readStream("accounts")
                .fromStart()
                .execute(1)
                .get()
                .getEvents()
                .get(0);

        AccountCreated writtenEvent = resolvedEvent.getOriginalEvent()
                .getEventDataAs(AccountCreated.class);

        System.out.println(writtenEvent);

//        client.connect("aStream", "aGroup", 32, new PersistentSubscriptionListener() {
//            private int count = 0;
//
//            @Override
//            public void onEvent(PersistentSubscription subscription, ResolvedEvent event) {
//                ++this.count;
//
//                subscription.ack(event);
//
//                if (this.count == 6) {
//                    result.complete(this.count);
//                    subscription.stop();
//                }
//            }
//
//            @Override
//            public void onError(PersistentSubscription subscription, Throwable throwable) {
//                result.completeExceptionally(throwable);
//            }
//
//            @Override
//            public void onCancelled(PersistentSubscription subscription) {
//                result.complete(count);
//            }
//        }).get();
//
//        events.clear();
//
//        for (int i = 0; i < 3; ++i) {
//            events.add(new ProposedEvent(UUID.randomUUID(), "foobar", "application/json", eventData, null));
//        }
//
//        streamsClient.appendToStream("aStream", ExpectedRevision.ANY, events).get();
    }
}
