/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionMetadata;
import com.eventstore.dbclient.EventStoreDBConnection;
import com.eventstore.dbclient.ExpectedRevision;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.NotLeaderException;
import com.eventstore.dbclient.Position;
import com.eventstore.dbclient.ProposedEvent;
import com.eventstore.dbclient.StreamRevision;
import com.eventstore.dbclient.Timeouts;
import com.eventstore.dbclient.UserCredentials;
import com.eventstore.dbclient.WriteResult;
import com.eventstore.dbclient.WrongExpectedVersionException;
import com.eventstore.dbclient.proto.shared.Shared;
import com.eventstore.dbclient.proto.streams.StreamsGrpc;
import com.eventstore.dbclient.proto.streams.StreamsOuterClass;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;

public class AppendToStream {
    private EventStoreDBConnection connection;
    private String streamName;
    private ExpectedRevision expectedRevision;
    private List<ProposedEvent> events;
    private Timeouts timeouts;
    private ConnectionMetadata metadata;

    public AppendToStream(EventStoreDBConnection connection, String streamName, UserCredentials credentials) {
        this.connection = connection;
        this.streamName = streamName;
        this.expectedRevision = ExpectedRevision.ANY;
        this.events = new ArrayList<ProposedEvent>();
        this.timeouts = Timeouts.DEFAULT;
        this.metadata = new ConnectionMetadata();
        if (credentials != null) {
            this.metadata.authenticated(credentials);
        }
    }

    public AppendToStream authenticated(UserCredentials credentials) {
        this.metadata.authenticated(credentials);
        return this;
    }

    public AppendToStream expectedRevision(ExpectedRevision revision) {
        this.expectedRevision = revision;
        return this;
    }

    public AppendToStream timeouts(Timeouts timeouts) {
        this.timeouts = timeouts;
        return this;
    }

    public AppendToStream requiresLeader() {
        return this.requiresLeader(true);
    }

    public AppendToStream notRequireLeader() {
        return this.requiresLeader(false);
    }

    public AppendToStream requiresLeader(boolean value) {
        if (value) {
            this.metadata.requiresLeader();
        }
        return this;
    }

    public AppendToStream addEvent(ProposedEvent event) {
        this.events.add(event);
        return this;
    }

    public AppendToStream addEvents(ProposedEvent ... events) {
        this.addEvents(Arrays.stream(events).iterator());
        return this;
    }

    public AppendToStream addEvents(Iterator<ProposedEvent> events) {
        while (events.hasNext()) {
            this.events.add(events.next());
        }
        return this;
    }

    public CompletableFuture<WriteResult> execute() {
        return this.connection.run(channel -> {
            Metadata headers = this.metadata.build();
            CompletableFuture result = new CompletableFuture();
            StreamsOuterClass.AppendReq.Options.Builder options = this.expectedRevision.applyOnWire(StreamsOuterClass.AppendReq.Options.newBuilder().setStreamIdentifier(Shared.StreamIdentifier.newBuilder().setStreamName(ByteString.copyFromUtf8((String)this.streamName)).build()));
            StreamsGrpc.StreamsStub client = (StreamsGrpc.StreamsStub)MetadataUtils.attachHeaders((AbstractStub)StreamsGrpc.newStub((Channel)channel), (Metadata)headers);
            StreamObserver<StreamsOuterClass.AppendReq> requestStream = client.append((StreamObserver<StreamsOuterClass.AppendResp>)GrpcUtils.convertSingleResponse(result, resp -> {
                if (resp.hasSuccess()) {
                    StreamsOuterClass.AppendResp.Success success = resp.getSuccess();
                    StreamRevision nextExpectedRevision = success.getCurrentRevisionOptionCase() == StreamsOuterClass.AppendResp.Success.CurrentRevisionOptionCase.NO_STREAM ? new StreamRevision(1L) : new StreamRevision(success.getCurrentRevision());
                    Position logPosition = null;
                    if (success.getPositionOptionCase() == StreamsOuterClass.AppendResp.Success.PositionOptionCase.POSITION) {
                        StreamsOuterClass.AppendResp.Position p = success.getPosition();
                        logPosition = new Position(p.getCommitPosition(), p.getPreparePosition());
                    }
                    return new WriteResult(nextExpectedRevision, logPosition);
                }
                if (resp.hasWrongExpectedVersion()) {
                    StreamsOuterClass.AppendResp.WrongExpectedVersion wev = resp.getWrongExpectedVersion();
                    StreamRevision expectedRevision = wev.getExpectedRevisionOptionCase() == StreamsOuterClass.AppendResp.WrongExpectedVersion.ExpectedRevisionOptionCase.ANY ? new StreamRevision(2L) : (wev.getExpectedRevisionOptionCase() == StreamsOuterClass.AppendResp.WrongExpectedVersion.ExpectedRevisionOptionCase.STREAM_EXISTS ? new StreamRevision(4L) : new StreamRevision(wev.getExpectedRevision()));
                    StreamRevision currentRevision = wev.getCurrentRevisionOptionCase() == StreamsOuterClass.AppendResp.WrongExpectedVersion.CurrentRevisionOptionCase.NO_STREAM ? new StreamRevision(2L) : new StreamRevision(wev.getCurrentRevision());
                    String streamName = options.getStreamIdentifier().getStreamName().toStringUtf8();
                    throw new WrongExpectedVersionException(streamName, expectedRevision, currentRevision);
                }
                throw new IllegalStateException("AppendResponse has neither Success or WrongExpectedVersion variants");
            }));
            try {
                requestStream.onNext((Object)StreamsOuterClass.AppendReq.newBuilder().setOptions(options).build());
                for (ProposedEvent e : this.events) {
                    StreamsOuterClass.AppendReq.ProposedMessage.Builder msgBuilder = StreamsOuterClass.AppendReq.ProposedMessage.newBuilder().setId(Shared.UUID.newBuilder().setStructured(Shared.UUID.Structured.newBuilder().setMostSignificantBits(e.getEventId().getMostSignificantBits()).setLeastSignificantBits(e.getEventId().getLeastSignificantBits()))).setData(ByteString.copyFrom((byte[])e.getEventData())).putMetadata("content-type", e.getContentType()).putMetadata("type", e.getEventType());
                    if (e.getUserMetadata() != null) {
                        msgBuilder.setCustomMetadata(ByteString.copyFrom((byte[])e.getUserMetadata()));
                    }
                    requestStream.onNext((Object)StreamsOuterClass.AppendReq.newBuilder().setProposedMessage(msgBuilder).build());
                }
                requestStream.onCompleted();
            }
            catch (StatusRuntimeException e) {
                String leaderHost = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-host", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                String leaderPort = (String)e.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-port", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                if (leaderHost != null && leaderPort != null) {
                    NotLeaderException reason = new NotLeaderException(leaderHost, Integer.valueOf(leaderPort));
                    result.completeExceptionally(reason);
                } else {
                    result.completeExceptionally(e);
                }
            }
            catch (RuntimeException e) {
                result.completeExceptionally(e);
            }
            return result;
        });
    }
}

