/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ClusterInfo;
import com.eventstore.dbclient.GossipClient;
import com.eventstore.dbclient.NodePreference;
import com.eventstore.dbclient.Timeouts;
import io.grpc.Attributes;
import io.grpc.EquivalentAddressGroup;
import io.grpc.ManagedChannel;
import io.grpc.NameResolver;
import io.grpc.NameResolverProvider;
import io.grpc.Status;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public class ClusterResolverFactory
extends NameResolverProvider {
    private static final Set<ClusterInfo.MemberState> invalidStates;
    private static final Random random;
    private List<InetSocketAddress> seedNodes;
    private final NodePreference nodePreference;
    private final SslContext sslContext;
    private final Timeouts timeouts;

    public ClusterResolverFactory(List<InetSocketAddress> seedNodes, NodePreference nodePreference, Timeouts timeouts, SslContext sslContext) {
        this.seedNodes = seedNodes;
        this.nodePreference = nodePreference;
        this.sslContext = sslContext;
        this.timeouts = timeouts;
    }

    public NameResolver newNameResolver(final URI targetUri, NameResolver.Args args) {
        return new NameResolver(){

            public String getServiceAuthority() {
                return "eventStoreDBGossip";
            }

            public void start(NameResolver.Listener2 listener) {
                ArrayList<InetSocketAddress> candidates;
                if (ClusterResolverFactory.this.seedNodes != null) {
                    candidates = new ArrayList(ClusterResolverFactory.this.seedNodes);
                    Collections.shuffle(candidates);
                } else {
                    candidates = new ArrayList<InetSocketAddress>();
                    try {
                        Record[] records = new Lookup(targetUri.getHost(), 33).run();
                        for (int i = 0; i < records.length; ++i) {
                            SRVRecord record = (SRVRecord)records[i];
                            candidates.add(new InetSocketAddress(record.getName().toString(true), record.getPort()));
                        }
                    }
                    catch (TextParseException e) {
                        listener.onError(Status.INTERNAL);
                    }
                }
                for (InetSocketAddress seed : candidates) {
                    try {
                        ClusterInfo.Endpoint endpoint = (ClusterInfo.Endpoint)ClusterResolverFactory.this.attemptDiscovery(seed).get();
                        if (endpoint == null) continue;
                        InetSocketAddress addr = endpoint.toInetSocketAddress();
                        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
                        addrs.add(addr);
                        EquivalentAddressGroup addrGroup = new EquivalentAddressGroup(addrs);
                        ArrayList<EquivalentAddressGroup> addrGroups = new ArrayList<EquivalentAddressGroup>();
                        addrGroups.add(addrGroup);
                        listener.onResult(NameResolver.ResolutionResult.newBuilder().setAddresses(addrGroups).setAttributes(Attributes.EMPTY).build());
                        return;
                    }
                    catch (InterruptedException | ExecutionException e) {
                        listener.onError(Status.INTERNAL);
                        return;
                    }
                }
            }

            public void shutdown() {
            }
        };
    }

    public String getDefaultScheme() {
        return this.seedNodes != null ? "cluster_seeds" : "cluster_dns";
    }

    private CompletableFuture<ClusterInfo.Endpoint> attemptDiscovery(InetSocketAddress seed) {
        ManagedChannel channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((SocketAddress)seed).userAgent("Event Store Client (Java) v1.0.0-SNAPSHOT")).sslContext(this.sslContext).build();
        GossipClient client = new GossipClient(channel, this.timeouts);
        return ((CompletableFuture)client.read().thenApply(this::determineBestFitNode)).thenApply(m -> m.map(ClusterInfo.Member::getHttpEndpoint).orElse(null));
    }

    private Optional<ClusterInfo.Member> determineBestFitNode(ClusterInfo clusterInfo) {
        return clusterInfo.getMembers().stream().filter(ClusterInfo.Member::isAlive).filter(m -> !invalidStates.contains((Object)m.getState())).sorted((o1, o2) -> {
            switch (this.nodePreference) {
                case LEADER: {
                    if (o1.getState().equals((Object)ClusterInfo.MemberState.LEADER)) {
                        return -1;
                    }
                    if (o2.getState().equals((Object)ClusterInfo.MemberState.LEADER)) {
                        return 1;
                    }
                    return 0;
                }
                case FOLLOWER: {
                    if (o1.getState().equals((Object)ClusterInfo.MemberState.FOLLOWER)) {
                        return -1;
                    }
                    if (o2.getState().equals((Object)ClusterInfo.MemberState.FOLLOWER)) {
                        return 1;
                    }
                    return 0;
                }
                case READ_ONLY_REPLICA: {
                    if (o1.getState().equals((Object)ClusterInfo.MemberState.READ_ONLY_REPLICA)) {
                        return -1;
                    }
                    if (o2.getState().equals((Object)ClusterInfo.MemberState.READ_ONLY_REPLICA)) {
                        return 1;
                    }
                    return 0;
                }
                case RANDOM: {
                    if (random.nextBoolean()) {
                        return 1;
                    }
                    return 1;
                }
            }
            return 0;
        }).findFirst();
    }

    protected boolean isAvailable() {
        return true;
    }

    protected int priority() {
        return 6;
    }

    static {
        random = new Random();
        invalidStates = new HashSet<ClusterInfo.MemberState>(){
            {
                this.add(ClusterInfo.MemberState.MANAGER);
                this.add(ClusterInfo.MemberState.SHUTTING_DOWN);
                this.add(ClusterInfo.MemberState.SHUT_DOWN);
                this.add(ClusterInfo.MemberState.UNKNOWN);
                this.add(ClusterInfo.MemberState.INITIALIZING);
                this.add(ClusterInfo.MemberState.RESIGNING_LEADER);
                this.add(ClusterInfo.MemberState.PRE_LEADER);
                this.add(ClusterInfo.MemberState.PRE_REPLICA);
                this.add(ClusterInfo.MemberState.PRE_READ_ONLY_REPLICA);
                this.add(ClusterInfo.MemberState.CLONE);
                this.add(ClusterInfo.MemberState.DISCOVER_LEADER);
            }
        };
    }
}

