/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Endpoint;
import com.eventstore.dbclient.EventStoreDBClusterConnection;
import com.eventstore.dbclient.EventStoreDBConnection;
import com.eventstore.dbclient.NodePreference;
import com.eventstore.dbclient.SingleNodeEventStoreDBConnection;
import com.eventstore.dbclient.Timeouts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.util.ArrayList;

public class ConnectionBuilder {
    private Timeouts _timeouts = Timeouts.DEFAULT;
    private SslContext _sslContext = null;

    public ConnectionBuilder connectionTimeouts(Timeouts timeouts) {
        this._timeouts = timeouts;
        return this;
    }

    public ConnectionBuilder sslContext(SslContext context) {
        this._sslContext = context;
        return this;
    }

    public EventStoreDBConnection createSingleNodeConnection(Endpoint endpoint) {
        return new SingleNodeEventStoreDBConnection(endpoint.getHostname(), endpoint.getPort(), this._timeouts, this._sslContext);
    }

    public EventStoreDBConnection createSingleNodeConnection(String hostname, int port) {
        return this.createSingleNodeConnection(new Endpoint(hostname, port));
    }

    public EventStoreDBConnection createClusterConnectionUsingSeeds(Endpoint[] endpoints) {
        return this.createClusterConnectionUsingSeeds(endpoints, NodePreference.RANDOM);
    }

    public EventStoreDBConnection createClusterConnectionUsingSeeds(Endpoint[] endpoints, NodePreference nodePreference) {
        ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
        for (int i = 0; i < endpoints.length; ++i) {
            Endpoint seed = endpoints[i];
            InetSocketAddress address = new InetSocketAddress(seed.getHostname(), seed.getPort());
            addresses.add(address);
        }
        return new EventStoreDBClusterConnection(addresses, null, nodePreference, this._timeouts, this._sslContext);
    }

    public EventStoreDBConnection createClusterConnectionUsingDns(String domain) {
        return this.createClusterConnectionUsingDns(domain, NodePreference.RANDOM);
    }

    public EventStoreDBConnection createClusterConnectionUsingDns(String domain, NodePreference nodePreference) {
        return new EventStoreDBClusterConnection(null, domain, nodePreference, this._timeouts, this._sslContext);
    }
}

