/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ClusterInfo;
import com.eventstore.dbclient.ConnectionShutdownException;
import com.eventstore.dbclient.Endpoint;
import com.eventstore.dbclient.EventStoreDBConnection;
import com.eventstore.dbclient.GossipClient;
import com.eventstore.dbclient.NoClusterNodeFound;
import com.eventstore.dbclient.NodePreference;
import com.eventstore.dbclient.NotLeaderException;
import com.eventstore.dbclient.Timeouts;
import com.eventstore.dbclient.Tuple;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.function.Function;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.SRVRecord;
import org.xbill.DNS.TextParseException;

public class EventStoreDBClusterConnection
implements EventStoreDBConnection {
    private static final Set<ClusterInfo.MemberState> invalidStates;
    private static final Random random;
    private volatile boolean shutdown = false;
    private boolean doDraining = true;
    private UUID currentChannelId;
    private ManagedChannel channel;
    private Exception lastException;
    private List<InetSocketAddress> seedNodes;
    private final NodePreference nodePreference;
    private final String domainName;
    private final SslContext sslContext;
    private final Timeouts timeouts;
    private LinkedBlockingQueue<Msg> messages;

    public EventStoreDBClusterConnection(List<InetSocketAddress> seedNodes, String domainName, NodePreference nodePreference, Timeouts timeouts, SslContext sslContext) {
        this.seedNodes = seedNodes;
        this.nodePreference = nodePreference;
        this.sslContext = sslContext;
        this.timeouts = timeouts;
        this.domainName = domainName;
        this.currentChannelId = UUID.randomUUID();
        try {
            this.messages.put(new CreateChannel(this.currentChannelId));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        CompletableFuture.runAsync(() -> this.messageLoop());
    }

    private ManagedChannel createChannel(Endpoint endpoint) {
        NettyChannelBuilder builder = NettyChannelBuilder.forAddress((String)endpoint.getHostname(), (int)endpoint.getPort());
        if (this.sslContext == null) {
            builder.usePlaintext();
        } else {
            builder.sslContext(this.sslContext);
        }
        return builder.build();
    }

    private void messageLoop() {
        try {
            Msg msg;
            while ((msg = this.messages.take()).accept(this)) {
            }
            this.shutdown = true;
        }
        catch (InterruptedException e) {
            this.lastException = e;
            this.shutdown = true;
            this.doDraining = false;
        }
        if (this.doDraining) {
            ArrayList msgs = new ArrayList();
            this.messages.drainTo(msgs);
            for (Msg msg : msgs) {
                msg.accept(this);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Tuple<Endpoint, Exception> nodeSelection() {
        ArrayList<Object> candidates;
        if (this.seedNodes != null) {
            candidates = new ArrayList<InetSocketAddress>(this.seedNodes);
            Collections.shuffle(candidates);
        } else {
            candidates = new ArrayList();
            try {
                void var3_5;
                Record[] records = new Lookup(this.domainName, 33).run();
                boolean bl = false;
                while (var3_5 < records.length) {
                    SRVRecord record = (SRVRecord)records[var3_5];
                    candidates.add(new InetSocketAddress(record.getName().toString(true), record.getPort()));
                    ++var3_5;
                }
            }
            catch (TextParseException e) {
                return new Tuple<Object, TextParseException>(null, e);
            }
        }
        for (InetSocketAddress inetSocketAddress : candidates) {
            try {
                ClusterInfo.Endpoint endpoint = this.attemptDiscovery(inetSocketAddress).get();
                if (endpoint == null) continue;
                Endpoint result = new Endpoint(endpoint.getAddress(), endpoint.getPort());
                return new Tuple<Endpoint, Object>(result, null);
            }
            catch (InterruptedException | ExecutionException e) {
                return new Tuple<Object, Exception>(null, e);
            }
        }
        return new Tuple<Object, NoClusterNodeFound>(null, new NoClusterNodeFound());
    }

    private CompletableFuture<ClusterInfo.Endpoint> attemptDiscovery(InetSocketAddress seed) {
        ManagedChannel channel = ((NettyChannelBuilder)NettyChannelBuilder.forAddress((SocketAddress)seed).userAgent("Event Store Client (Java) v1.0.0-SNAPSHOT")).sslContext(this.sslContext).build();
        GossipClient client = new GossipClient(channel, this.timeouts);
        return ((CompletableFuture)client.read().thenApply(this::determineBestFitNode)).thenApply(m -> m.map(ClusterInfo.Member::getHttpEndpoint).orElse(null));
    }

    private Optional<ClusterInfo.Member> determineBestFitNode(ClusterInfo clusterInfo) {
        return clusterInfo.getMembers().stream().filter(ClusterInfo.Member::isAlive).filter(m -> !invalidStates.contains((Object)m.getState())).sorted((o1, o2) -> {
            switch (this.nodePreference) {
                case LEADER: {
                    if (o1.getState().equals((Object)ClusterInfo.MemberState.LEADER)) {
                        return -1;
                    }
                    if (o2.getState().equals((Object)ClusterInfo.MemberState.LEADER)) {
                        return 1;
                    }
                    return 0;
                }
                case FOLLOWER: {
                    if (o1.getState().equals((Object)ClusterInfo.MemberState.FOLLOWER)) {
                        return -1;
                    }
                    if (o2.getState().equals((Object)ClusterInfo.MemberState.FOLLOWER)) {
                        return 1;
                    }
                    return 0;
                }
                case READ_ONLY_REPLICA: {
                    if (o1.getState().equals((Object)ClusterInfo.MemberState.READ_ONLY_REPLICA)) {
                        return -1;
                    }
                    if (o2.getState().equals((Object)ClusterInfo.MemberState.READ_ONLY_REPLICA)) {
                        return 1;
                    }
                    return 0;
                }
                case RANDOM: {
                    if (random.nextBoolean()) {
                        return 1;
                    }
                    return 1;
                }
            }
            return 0;
        }).findFirst();
    }

    @Override
    public <A> CompletableFuture<A> run(final Function<ManagedChannel, CompletableFuture<A>> action) {
        final CompletableFuture result = new CompletableFuture();
        final EventStoreDBClusterConnection self = this;
        this.messages.add(new RunWorkItem(new WorkItem(){

            @Override
            public void execute(UUID id, ManagedChannel channel, Exception fatalError) {
                if (fatalError != null) {
                    result.completeExceptionally(fatalError);
                    return;
                }
                ((CompletableFuture)action.apply(channel)).whenComplete((outcome, error) -> {
                    StatusRuntimeException ex;
                    if (outcome != null) {
                        result.complete(outcome);
                        return;
                    }
                    if (error instanceof NotLeaderException) {
                        NotLeaderException ex2 = (NotLeaderException)error;
                        result.completeExceptionally(ex2);
                        try {
                            self.messages.put(new CreateChannel(id, ex2.getLeaderEndpoint()));
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        return;
                    }
                    if (error instanceof StatusRuntimeException && (ex = (StatusRuntimeException)((Object)error)).getStatus().getCode().equals((Object)Status.Code.UNAVAILABLE)) {
                        self.messages.add(new CreateChannel(id));
                    }
                    result.completeExceptionally((Throwable)error);
                });
            }
        }));
        return result;
    }

    private boolean createNewChannel(UUID previousId, Optional<Endpoint> candidate) {
        if (this.currentChannelId.equals(previousId)) {
            this.currentChannelId = UUID.randomUUID();
            if (candidate.isPresent()) {
                this.channel = this.createChannel(candidate.get());
            } else {
                Tuple<Endpoint, Exception> result = this.nodeSelection();
                if (result.get_2() == null) {
                    this.channel = this.createChannel(result.get_1());
                } else {
                    this.lastException = result.get_2();
                    return false;
                }
            }
        }
        return true;
    }

    private boolean runWorkItem(WorkItem item) {
        if (this.shutdown) {
            Exception e = this.lastException != null ? this.lastException : new ConnectionShutdownException();
            item.execute(null, null, e);
        } else if (this.channel == null) {
            try {
                this.messages.put(new RunWorkItem(item));
            }
            catch (InterruptedException e) {
                item.execute(null, null, e);
            }
        } else {
            item.execute(this.currentChannelId, this.channel, null);
        }
        return true;
    }

    private void closeConnection() {
        if (this.channel != null) {
            try {
                this.channel.shutdown().awaitTermination(Timeouts.DEFAULT.shutdownTimeout, Timeouts.DEFAULT.shutdownTimeoutUnit);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            finally {
                this.channel = null;
            }
        }
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.sendMessage(new Shutdown());
    }

    private void sendMessage(Msg msg) throws InterruptedException {
        if (!this.shutdown) {
            this.messages.add(msg);
        } else if (msg instanceof RunWorkItem) {
            RunWorkItem workItem = (RunWorkItem)msg;
            workItem.reportError(new ConnectionShutdownException());
        }
    }

    static {
        random = new Random();
        invalidStates = new HashSet<ClusterInfo.MemberState>(){
            {
                this.add(ClusterInfo.MemberState.MANAGER);
                this.add(ClusterInfo.MemberState.SHUTTING_DOWN);
                this.add(ClusterInfo.MemberState.SHUT_DOWN);
                this.add(ClusterInfo.MemberState.UNKNOWN);
                this.add(ClusterInfo.MemberState.INITIALIZING);
                this.add(ClusterInfo.MemberState.RESIGNING_LEADER);
                this.add(ClusterInfo.MemberState.PRE_LEADER);
                this.add(ClusterInfo.MemberState.PRE_REPLICA);
                this.add(ClusterInfo.MemberState.PRE_READ_ONLY_REPLICA);
                this.add(ClusterInfo.MemberState.CLONE);
                this.add(ClusterInfo.MemberState.DISCOVER_LEADER);
            }
        };
    }

    class Shutdown
    implements Msg {
        Shutdown() {
        }

        @Override
        public boolean accept(EventStoreDBClusterConnection self) {
            self.closeConnection();
            return false;
        }
    }

    class RunWorkItem
    implements Msg {
        final WorkItem item;

        RunWorkItem(WorkItem item) {
            this.item = item;
        }

        @Override
        public boolean accept(EventStoreDBClusterConnection self) {
            return self.runWorkItem(this.item);
        }

        void reportError(Exception e) {
            this.item.execute(null, null, e);
        }
    }

    class CreateChannel
    implements Msg {
        final Optional<Endpoint> channel;
        final UUID previousId;

        CreateChannel(UUID previousId) {
            this.channel = Optional.empty();
            this.previousId = previousId;
        }

        CreateChannel(UUID previousId, Endpoint endpoint) {
            this.channel = Optional.of(endpoint);
            this.previousId = previousId;
        }

        @Override
        public boolean accept(EventStoreDBClusterConnection self) {
            return self.createNewChannel(this.previousId, this.channel);
        }
    }

    static interface Msg {
        public boolean accept(EventStoreDBClusterConnection var1);
    }

    static interface WorkItem {
        public void execute(UUID var1, ManagedChannel var2, Exception var3);
    }
}

