/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AccountCreated;
import com.eventstore.dbclient.Connections;
import com.eventstore.dbclient.EventStoreDBConnection;
import com.eventstore.dbclient.ProposedEvent;
import com.eventstore.dbclient.ResolvedEvent;
import com.eventstore.dbclient.Streams;
import com.eventstore.dbclient.WriteResult;
import java.util.UUID;

public class Main {
    public static void main(String[] args) throws Exception {
        EventStoreDBConnection connection = Connections.builder().createSingleNodeConnection("localhost", 2113);
        Streams streamsAPI = Streams.create(connection);
        AccountCreated createdEvent = new AccountCreated();
        createdEvent.setId(UUID.randomUUID());
        createdEvent.setLogin("ouros");
        ProposedEvent event = ProposedEvent.builderAsJson("account-created", createdEvent).build();
        WriteResult writeResult = streamsAPI.appendStream("accounts").addEvent(event).execute().get();
        ResolvedEvent resolvedEvent = streamsAPI.readStream("accounts").fromStart().execute(1L).get().getEvents().get(0);
        AccountCreated writtenEvent = resolvedEvent.getOriginalEvent().getEventDataAs(AccountCreated.class);
        System.out.println(writtenEvent);
    }
}

