/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectPersistentSubscription;
import com.eventstore.dbclient.CreatePersistentSubscription;
import com.eventstore.dbclient.DeletePersistentSubscription;
import com.eventstore.dbclient.EventStoreDBConnection;
import com.eventstore.dbclient.PersistentSubscriptionListener;
import com.eventstore.dbclient.UpdatePersistentSubscription;
import com.eventstore.dbclient.UserCredentials;

public class PersistentSubscriptions {
    private final EventStoreDBConnection connection;
    private final UserCredentials credentials;

    private PersistentSubscriptions(EventStoreDBConnection connection, UserCredentials credentials) {
        this.connection = connection;
        this.credentials = credentials;
    }

    public static PersistentSubscriptions create(EventStoreDBConnection connection) {
        return new PersistentSubscriptions(connection, null);
    }

    public static PersistentSubscriptions createWithDefaultCredentials(EventStoreDBConnection connection, String login, String password) {
        return PersistentSubscriptions.createWithDefaultCredentials(connection, new UserCredentials(login, password));
    }

    public static PersistentSubscriptions createWithDefaultCredentials(EventStoreDBConnection connection, UserCredentials credentials) {
        return new PersistentSubscriptions(connection, credentials);
    }

    public CreatePersistentSubscription create(String stream, String group) {
        return new CreatePersistentSubscription(this.connection, stream, group, this.credentials);
    }

    public UpdatePersistentSubscription update(String stream, String group) {
        return new UpdatePersistentSubscription(this.connection, stream, group, this.credentials);
    }

    public DeletePersistentSubscription delete(String stream, String group) {
        return new DeletePersistentSubscription(this.connection, stream, group, this.credentials);
    }

    public ConnectPersistentSubscription connect(String stream, String group, PersistentSubscriptionListener listener) {
        return new ConnectPersistentSubscription(this.connection, stream, group, this.credentials, listener);
    }
}

