/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ClientSettings;
import com.eventstore.dbclient.ConnectionBuilder;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.PersistentSubscriptions;
import com.eventstore.dbclient.Streams;
import com.eventstore.dbclient.UserCredentials;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import javax.net.ssl.SSLException;

public class Client {
    private final GrpcClient client;
    private final UserCredentials credentials;

    private Client(ClientSettings settings) {
        ConnectionBuilder builder = new ConnectionBuilder();
        this.credentials = settings.getDefaultCredentials() != null ? settings.getDefaultCredentials().toUserCredentials() : null;
        if (settings.isTls()) {
            try {
                SslContextBuilder sslContext = GrpcSslContexts.forClient();
                if (!settings.isTlsVerifyCert()) {
                    sslContext.trustManager(InsecureTrustManagerFactory.INSTANCE);
                }
                builder.sslContext(sslContext.build());
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
        }
        if (settings.isDnsDiscover()) {
            this.client = builder.createClusterConnectionUsingDns(settings.getHosts()[0].getHostname(), settings.getNodePreference());
            return;
        }
        if (settings.getHosts().length > 1) {
            this.client = builder.createClusterConnectionUsingSeeds(settings.getHosts(), settings.getNodePreference());
            return;
        }
        this.client = builder.createSingleNodeConnection(settings.getHosts()[0]);
    }

    public static Client create(ClientSettings settings) {
        return new Client(settings);
    }

    public Streams streams() {
        return new Streams(this.client, this.credentials);
    }

    public PersistentSubscriptions persistentSubscriptions() {
        return new PersistentSubscriptions(this.client, this.credentials);
    }

    public void shutdown() throws InterruptedException {
        this.client.shutdown();
    }
}

