/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionMetadata;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.PersistentSubscriptionSettings;
import com.eventstore.dbclient.UserCredentials;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import com.eventstore.dbclient.proto.shared.Shared;
import com.google.protobuf.ByteString;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class UpdatePersistentSubscription {
    private final GrpcClient connection;
    private final String stream;
    private final String group;
    private PersistentSubscriptionSettings settings;
    private ConnectionMetadata metadata;

    public UpdatePersistentSubscription(GrpcClient connection, String stream, String group, UserCredentials credentials) {
        this.connection = connection;
        this.stream = stream;
        this.group = group;
        this.settings = PersistentSubscriptionSettings.builder().build();
        this.metadata = new ConnectionMetadata();
        if (credentials != null) {
            this.metadata.authenticated(credentials);
        }
    }

    public UpdatePersistentSubscription authenticated(UserCredentials credentials) {
        this.metadata.authenticated(credentials);
        return this;
    }

    public UpdatePersistentSubscription settings(PersistentSubscriptionSettings settings) {
        this.settings = settings;
        return this;
    }

    public CompletableFuture execute() {
        return this.connection.run(channel -> {
            CompletableFuture result = new CompletableFuture();
            Metadata headers = this.metadata.build();
            PersistentSubscriptionsGrpc.PersistentSubscriptionsStub client = (PersistentSubscriptionsGrpc.PersistentSubscriptionsStub)MetadataUtils.attachHeaders((AbstractStub)PersistentSubscriptionsGrpc.newStub((Channel)channel), (Metadata)headers);
            Persistent.UpdateReq.Options.Builder builder = Persistent.UpdateReq.Options.newBuilder();
            Persistent.UpdateReq.Settings.Builder settingsBuilder = Persistent.UpdateReq.Settings.newBuilder();
            Shared.StreamIdentifier.Builder streamIdentifierBuilder = Shared.StreamIdentifier.newBuilder();
            settingsBuilder.setRevision(this.settings.getRevision()).setResolveLinks(this.settings.isResolveLinks()).setReadBatchSize(this.settings.getReadBatchSize()).setMinCheckpointCount(this.settings.getMinCheckpointCount()).setMaxCheckpointCount(this.settings.getMaxCheckpointCount()).setMessageTimeoutMs(this.settings.getMessageTimeoutMs()).setMaxSubscriberCount(this.settings.getMaxSubscriberCount()).setMaxRetryCount(this.settings.getMaxRetryCount()).setLiveBufferSize(this.settings.getLiveBufferSize()).setHistoryBufferSize(this.settings.getHistoryBufferSize()).setExtraStatistics(this.settings.isExtraStatistics()).setCheckpointAfterMs(this.settings.getCheckpointAfterMs());
            switch (this.settings.getStrategy()) {
                case DispatchToSingle: {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.DispatchToSingle);
                    break;
                }
                case RoundRobin: {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.RoundRobin);
                    break;
                }
                case Pinned: {
                    settingsBuilder.setNamedConsumerStrategy(Persistent.UpdateReq.ConsumerStrategy.Pinned);
                }
            }
            streamIdentifierBuilder.setStreamName(ByteString.copyFromUtf8((String)this.stream));
            builder.setSettings(settingsBuilder).setGroupName(this.group).setStreamIdentifier(streamIdentifierBuilder).build();
            Persistent.UpdateReq req = Persistent.UpdateReq.newBuilder().setOptions(builder).build();
            client.update(req, (StreamObserver<Persistent.UpdateResp>)GrpcUtils.convertSingleResponse(result, Function.identity()));
            return result;
        });
    }
}

