/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.NotLeaderException;
import com.eventstore.dbclient.PersistentSubscription;
import com.eventstore.dbclient.PersistentSubscriptionListener;
import com.eventstore.dbclient.ResolvedEvent;
import com.eventstore.dbclient.SubscribePersistentSubscriptionOptions;
import com.eventstore.dbclient.UnsupportedFeature;
import com.eventstore.dbclient.proto.persistentsubscriptions.Persistent;
import com.eventstore.dbclient.proto.persistentsubscriptions.PersistentSubscriptionsGrpc;
import com.eventstore.dbclient.proto.shared.Shared;
import io.grpc.Channel;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientResponseObserver;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

abstract class AbstractSubscribePersistentSubscription {
    protected static final Persistent.ReadReq.Options.Builder defaultReadOptions = Persistent.ReadReq.Options.newBuilder().setUuidOption(Persistent.ReadReq.Options.UUIDOption.newBuilder().setStructured(Shared.Empty.getDefaultInstance()));
    private final GrpcClient connection;
    private final String group;
    private final PersistentSubscriptionListener listener;
    private final SubscribePersistentSubscriptionOptions options;

    public AbstractSubscribePersistentSubscription(GrpcClient connection, String group, SubscribePersistentSubscriptionOptions options, PersistentSubscriptionListener listener) {
        this.connection = connection;
        this.group = group;
        this.options = options;
        this.listener = listener;
    }

    protected abstract Persistent.ReadReq.Options.Builder createOptions();

    public CompletableFuture<PersistentSubscription> execute() {
        return this.connection.runWithArgs(args -> {
            PersistentSubscriptionsGrpc.PersistentSubscriptionsStub client = GrpcUtils.configureStub(PersistentSubscriptionsGrpc.newStub((Channel)args.getChannel()), this.connection.getSettings(), this.options);
            final CompletableFuture result = new CompletableFuture();
            int bufferSize = this.options.getBufferSize();
            Persistent.ReadReq req = Persistent.ReadReq.newBuilder().setOptions(this.createOptions().setBufferSize(bufferSize).setGroupName(this.group)).build();
            if (req.getOptions().hasAll() && !args.supportFeature(32)) {
                result.completeExceptionally(new UnsupportedFeature());
            } else {
                ClientResponseObserver<Persistent.ReadReq, Persistent.ReadResp> observer = new ClientResponseObserver<Persistent.ReadReq, Persistent.ReadResp>(){
                    private boolean _confirmed;
                    private PersistentSubscription _subscription;
                    private ClientCallStreamObserver _requestStream;

                    public void beforeStart(ClientCallStreamObserver<Persistent.ReadReq> requestStream) {
                        this._requestStream = requestStream;
                    }

                    public void onNext(Persistent.ReadResp readResp) {
                        if (!this._confirmed && readResp.hasSubscriptionConfirmation()) {
                            this._confirmed = true;
                            this._subscription = new PersistentSubscription((ClientCallStreamObserver<Persistent.ReadReq>)this._requestStream, readResp.getSubscriptionConfirmation().getSubscriptionId());
                            result.complete(this._subscription);
                            return;
                        }
                        if (!this._confirmed && readResp.hasEvent()) {
                            this.onError(new IllegalStateException("Unconfirmed persistent subscription received event"));
                            return;
                        }
                        if (this._confirmed && !readResp.hasEvent()) {
                            this.onError(new IllegalStateException(String.format("Confirmed persistent subscription %s received non-{event,checkpoint} variant", this._subscription.getSubscriptionId())));
                            return;
                        }
                        AbstractSubscribePersistentSubscription.this.listener.onEvent(this._subscription, ResolvedEvent.fromWire(readResp.getEvent()));
                    }

                    public void onError(Throwable throwable) {
                        Throwable error;
                        if (!this._confirmed) {
                            result.completeExceptionally(throwable);
                        }
                        if ((error = throwable) instanceof StatusRuntimeException) {
                            StatusRuntimeException sre = (StatusRuntimeException)error;
                            if (sre.getStatus().getCode() == Status.Code.CANCELLED) {
                                AbstractSubscribePersistentSubscription.this.listener.onCancelled(this._subscription);
                                return;
                            }
                            String leaderHost = (String)sre.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-host", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                            String leaderPort = (String)sre.getTrailers().get(Metadata.Key.of((String)"leader-endpoint-port", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER));
                            if (leaderHost != null && leaderPort != null) {
                                error = new NotLeaderException(leaderHost, Integer.valueOf(leaderPort));
                            }
                        }
                        AbstractSubscribePersistentSubscription.this.listener.onError(this._subscription, error);
                    }

                    public void onCompleted() {
                    }
                };
                StreamObserver<Persistent.ReadReq> wireStream = client.read((StreamObserver<Persistent.ReadResp>)observer);
                wireStream.onNext((Object)req);
            }
            return result;
        });
    }
}

