/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ClusterInfo;
import com.eventstore.dbclient.Endpoint;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.GossipClient;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.NoClusterNodeFound;
import com.eventstore.dbclient.NodePreference;
import com.eventstore.dbclient.NodeSelector;
import com.eventstore.dbclient.Tuple;
import io.grpc.ManagedChannel;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStoreDBClusterClient
extends GrpcClient {
    private final Logger logger = LoggerFactory.getLogger(EventStoreDBClusterClient.class);
    private final List<InetSocketAddress> seedNodes;
    private final NodeSelector nodeSelector;
    private final Endpoint domainEndpoint;

    public EventStoreDBClusterClient(List<InetSocketAddress> seedNodes, Endpoint domainEndpoint, NodePreference nodePreference, SslContext sslContext, EventStoreDBClientSettings settings) {
        super(settings, sslContext);
        this.seedNodes = seedNodes;
        this.nodeSelector = new NodeSelector(nodePreference);
        this.domainEndpoint = domainEndpoint;
        this.startConnectionLoop();
    }

    private Tuple<Endpoint, Exception> nodeSelection() {
        ArrayList<Object> candidates;
        if (this.seedNodes != null) {
            candidates = new ArrayList<InetSocketAddress>(this.seedNodes);
            Collections.shuffle(candidates);
        } else {
            candidates = new ArrayList<InetSocketAddress>();
            candidates.add(new InetSocketAddress(this.domainEndpoint.getHostname(), this.domainEndpoint.getPort()));
        }
        for (InetSocketAddress inetSocketAddress : candidates) {
            this.logger.debug("Using seed node [{}] for cluster node discovery.", (Object)inetSocketAddress);
            try {
                Optional<ClusterInfo.Member> optionalMember = this.attemptDiscovery(inetSocketAddress).get(this.settings.getGossipTimeout(), TimeUnit.MILLISECONDS);
                if (!optionalMember.isPresent()) continue;
                ClusterInfo.Member member = optionalMember.get();
                ClusterInfo.Endpoint endpoint = member.getHttpEndpoint();
                Endpoint result = new Endpoint(endpoint.getAddress(), endpoint.getPort());
                this.logger.debug("Selected cluster node [{}] in state [{}] for connection attempt.", (Object)result, (Object)member.getState());
                return new Tuple<Endpoint, Object>(result, null);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                this.logger.error("Exception during the node selection process", (Throwable)e);
            }
        }
        return new Tuple<Object, NoClusterNodeFound>(null, new NoClusterNodeFound());
    }

    private CompletableFuture<Optional<ClusterInfo.Member>> attemptDiscovery(InetSocketAddress seed) {
        NettyChannelBuilder builder = (NettyChannelBuilder)NettyChannelBuilder.forAddress((SocketAddress)seed).userAgent("EventStoreDB Client (Java)");
        if (this.sslContext == null) {
            builder.usePlaintext();
        } else {
            builder.sslContext(this.sslContext);
        }
        ManagedChannel channel = builder.build();
        GossipClient client = new GossipClient(channel);
        return ((CompletableFuture)client.read().whenComplete((v, e) -> client.shutdown())).thenApply(this.nodeSelector::determineBestFitNode);
    }

    @Override
    protected boolean doConnect() {
        Tuple<Endpoint, Exception> result = this.nodeSelection();
        if (result.get_2() != null) {
            this.logger.warn("Could not determine cluster node for connection attempt.");
            this.lastException = result.get_2();
            return false;
        }
        this.endpoint = result.get_1();
        this.channel = this.createChannel(this.endpoint);
        return true;
    }
}

