/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.AbortProjection;
import com.eventstore.dbclient.AbortProjectionOptions;
import com.eventstore.dbclient.CreateProjection;
import com.eventstore.dbclient.CreateProjectionOptions;
import com.eventstore.dbclient.DeleteProjection;
import com.eventstore.dbclient.DeleteProjectionOptions;
import com.eventstore.dbclient.DisableProjection;
import com.eventstore.dbclient.DisableProjectionOptions;
import com.eventstore.dbclient.EnableProjection;
import com.eventstore.dbclient.EnableProjectionOptions;
import com.eventstore.dbclient.EventStoreDBClientBase;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.GetProjectionResult;
import com.eventstore.dbclient.GetProjectionResultOptions;
import com.eventstore.dbclient.GetProjectionState;
import com.eventstore.dbclient.GetProjectionStateOptions;
import com.eventstore.dbclient.GetProjectionStatistics;
import com.eventstore.dbclient.GetProjectionStatisticsOptions;
import com.eventstore.dbclient.GetProjectionStatus;
import com.eventstore.dbclient.GetProjectionStatusOptions;
import com.eventstore.dbclient.ListProjections;
import com.eventstore.dbclient.ListProjectionsOptions;
import com.eventstore.dbclient.ListProjectionsResult;
import com.eventstore.dbclient.ProjectionDetails;
import com.eventstore.dbclient.ResetProjection;
import com.eventstore.dbclient.ResetProjectionOptions;
import com.eventstore.dbclient.RestartProjectionSubsystem;
import com.eventstore.dbclient.RestartProjectionSubsystemOptions;
import com.eventstore.dbclient.UpdateProjection;
import com.eventstore.dbclient.UpdateProjectionOptions;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public class EventStoreDBProjectionManagementClient
extends EventStoreDBClientBase {
    private EventStoreDBProjectionManagementClient(EventStoreDBClientSettings settings) {
        super(settings);
    }

    public static EventStoreDBProjectionManagementClient create(EventStoreDBClientSettings settings) {
        return new EventStoreDBProjectionManagementClient(settings);
    }

    public CompletableFuture abort(String projectionName) {
        return this.abort(projectionName, AbortProjectionOptions.get());
    }

    public CompletableFuture abort(String projectionName, AbortProjectionOptions options) {
        return new AbortProjection(this.client, projectionName, options).execute();
    }

    public CompletableFuture create(String projectionName, String query) {
        return this.create(projectionName, query, CreateProjectionOptions.get());
    }

    public CompletableFuture create(String projectionName, String query, CreateProjectionOptions options) {
        if (options == null) {
            options = CreateProjectionOptions.get();
        }
        if (!options.hasUserCredentials()) {
            options.authenticated(this.credentials);
        }
        return new CreateProjection(this.client, projectionName, query, options).execute();
    }

    public CompletableFuture enable(String projectionName) {
        return this.enable(projectionName, EnableProjectionOptions.get());
    }

    public CompletableFuture enable(String projectionName, EnableProjectionOptions options) {
        return new EnableProjection(this.client, projectionName, options).execute();
    }

    public CompletableFuture delete(String projectionName) {
        return this.delete(projectionName, DeleteProjectionOptions.get());
    }

    public CompletableFuture delete(String projectionName, DeleteProjectionOptions options) {
        return new DeleteProjection(this.client, projectionName, options).execute();
    }

    public CompletableFuture disable(String projectionName) {
        return this.disable(projectionName, DisableProjectionOptions.get());
    }

    public CompletableFuture disable(String projectionName, DisableProjectionOptions options) {
        return new DisableProjection(this.client, projectionName, options).execute();
    }

    public <TResult> CompletableFuture<TResult> getResult(String projectionName, Class<TResult> type) {
        return this.getResult(projectionName, type, GetProjectionResultOptions.get());
    }

    public <TResult> CompletableFuture<TResult> getResult(String projectionName, Class<TResult> type, GetProjectionResultOptions options) {
        return new GetProjectionResult<TResult>(this.client, projectionName, options, type).execute();
    }

    public <TResult> CompletableFuture<TResult> getResult(String projectionName, Function<TypeFactory, JavaType> javaTypeFunction) {
        return this.getResult(projectionName, javaTypeFunction, GetProjectionResultOptions.get());
    }

    public <TResult> CompletableFuture<TResult> getResult(String projectionName, Function<TypeFactory, JavaType> javaTypeFunction, GetProjectionResultOptions options) {
        return new GetProjectionResult(this.client, projectionName, options, javaTypeFunction).execute();
    }

    public <TResult> CompletableFuture<TResult> getState(String projectionName, Class<TResult> type) {
        return this.getState(projectionName, type, GetProjectionStateOptions.get());
    }

    public <TResult> CompletableFuture<TResult> getState(String projectionName, Class<TResult> type, GetProjectionStateOptions options) {
        return new GetProjectionState<TResult>(this.client, projectionName, options, type).execute();
    }

    public <TResult> CompletableFuture<TResult> getState(String projectionName, Function<TypeFactory, JavaType> javaTypeFunction) {
        return this.getState(projectionName, javaTypeFunction, GetProjectionStateOptions.get());
    }

    public <TResult> CompletableFuture<TResult> getState(String projectionName, Function<TypeFactory, JavaType> javaTypeFunction, GetProjectionStateOptions options) {
        return new GetProjectionState(this.client, projectionName, options, javaTypeFunction).execute();
    }

    public CompletableFuture<ProjectionDetails> getStatistics(String projectionName) {
        return this.getStatistics(projectionName, GetProjectionStatisticsOptions.get());
    }

    public CompletableFuture<ProjectionDetails> getStatistics(String projectionName, GetProjectionStatisticsOptions options) {
        return new GetProjectionStatistics(this.client, projectionName, options).execute();
    }

    public CompletableFuture<ProjectionDetails> getStatus(String projectionName) {
        return this.getStatus(projectionName, GetProjectionStatusOptions.get());
    }

    public CompletableFuture<ProjectionDetails> getStatus(String projectionName, GetProjectionStatusOptions options) {
        return new GetProjectionStatus(this.client, projectionName, options).execute();
    }

    public CompletableFuture<ListProjectionsResult> list() {
        return new ListProjections(this.client, ListProjectionsOptions.get()).execute();
    }

    public CompletableFuture<ListProjectionsResult> list(ListProjectionsOptions options) {
        return new ListProjections(this.client, options).execute();
    }

    public CompletableFuture reset(String projectionName) {
        return this.reset(projectionName, ResetProjectionOptions.get());
    }

    public CompletableFuture reset(String projectionName, ResetProjectionOptions options) {
        return new ResetProjection(this.client, projectionName, options).execute();
    }

    public CompletableFuture restartSubsystem() {
        return this.restartSubsystem(RestartProjectionSubsystemOptions.get());
    }

    public CompletableFuture restartSubsystem(RestartProjectionSubsystemOptions options) {
        return new RestartProjectionSubsystem(this.client, options).execute();
    }

    public CompletableFuture update(String projectionName, String query) {
        return this.update(projectionName, query, UpdateProjectionOptions.get());
    }

    public CompletableFuture update(String projectionName, String query, UpdateProjectionOptions options) {
        return new UpdateProjection(this.client, projectionName, query, options).execute();
    }
}

