/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.GrpcUtils;
import com.eventstore.dbclient.UpdateProjectionOptions;
import com.eventstore.dbclient.proto.projections.Projectionmanagement;
import com.eventstore.dbclient.proto.projections.ProjectionsGrpc;
import com.eventstore.dbclient.proto.shared.Shared;
import io.grpc.Channel;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.CompletableFuture;

class UpdateProjection {
    private final GrpcClient client;
    private final String projectionName;
    private final String query;
    private final Boolean emitEnabled;
    private final UpdateProjectionOptions options;

    public UpdateProjection(GrpcClient client, String projectionName, String query, UpdateProjectionOptions options) {
        this.client = client;
        this.projectionName = projectionName;
        this.query = query;
        this.emitEnabled = options.isEmitEnabled();
        this.options = options;
    }

    public CompletableFuture execute() {
        return this.client.run(channel -> {
            Projectionmanagement.UpdateReq.Options.Builder optionsBuilder = Projectionmanagement.UpdateReq.Options.newBuilder().setName(this.projectionName).setQuery(this.query);
            if (this.emitEnabled == null) {
                optionsBuilder.setNoEmitOptions(Shared.Empty.newBuilder());
            } else {
                optionsBuilder.setEmitEnabled(this.emitEnabled);
            }
            Projectionmanagement.UpdateReq request = Projectionmanagement.UpdateReq.newBuilder().setOptions(optionsBuilder).build();
            ProjectionsGrpc.ProjectionsStub client = GrpcUtils.configureStub(ProjectionsGrpc.newStub((Channel)channel), this.client.getSettings(), this.options);
            CompletableFuture result = new CompletableFuture();
            client.update(request, (StreamObserver<Projectionmanagement.UpdateResp>)GrpcUtils.convertSingleResponse(result));
            return result;
        });
    }
}

