/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.CreatePersistentSubscriptionToAll;
import com.eventstore.dbclient.CreatePersistentSubscriptionToAllOptions;
import com.eventstore.dbclient.CreatePersistentSubscriptionToStream;
import com.eventstore.dbclient.CreatePersistentSubscriptionToStreamOptions;
import com.eventstore.dbclient.DeletePersistentSubscriptionOptions;
import com.eventstore.dbclient.DeletePersistentSubscriptionToAll;
import com.eventstore.dbclient.DeletePersistentSubscriptionToStream;
import com.eventstore.dbclient.EventStoreDBClientBase;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.GetPersistentSubscriptionInfo;
import com.eventstore.dbclient.GetPersistentSubscriptionInfoOptions;
import com.eventstore.dbclient.ListPersistentSubscriptions;
import com.eventstore.dbclient.ListPersistentSubscriptionsOptions;
import com.eventstore.dbclient.PersistentSubscription;
import com.eventstore.dbclient.PersistentSubscriptionInfo;
import com.eventstore.dbclient.PersistentSubscriptionListener;
import com.eventstore.dbclient.PersistentSubscriptionToAllInfo;
import com.eventstore.dbclient.PersistentSubscriptionToStreamInfo;
import com.eventstore.dbclient.ReplayParkedMessages;
import com.eventstore.dbclient.ReplayParkedMessagesOptions;
import com.eventstore.dbclient.RestartPersistentSubscriptionSubsystem;
import com.eventstore.dbclient.RestartPersistentSubscriptionSubsystemOptions;
import com.eventstore.dbclient.SubscribePersistentSubscriptionOptions;
import com.eventstore.dbclient.SubscribePersistentSubscriptionToAll;
import com.eventstore.dbclient.SubscribePersistentSubscriptionToStream;
import com.eventstore.dbclient.UpdatePersistentSubscriptionToAll;
import com.eventstore.dbclient.UpdatePersistentSubscriptionToAllOptions;
import com.eventstore.dbclient.UpdatePersistentSubscriptionToStream;
import com.eventstore.dbclient.UpdatePersistentSubscriptionToStreamOptions;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class EventStoreDBPersistentSubscriptionsClient
extends EventStoreDBClientBase {
    private EventStoreDBPersistentSubscriptionsClient(EventStoreDBClientSettings settings) {
        super(settings);
    }

    public static EventStoreDBPersistentSubscriptionsClient create(EventStoreDBClientSettings settings) {
        return new EventStoreDBPersistentSubscriptionsClient(settings);
    }

    public CompletableFuture createToStream(String stream, String group) {
        return this.createToStream(stream, group, CreatePersistentSubscriptionToStreamOptions.get());
    }

    public CompletableFuture createToAll(String group) {
        return this.createToAll(group, CreatePersistentSubscriptionToAllOptions.get());
    }

    public CompletableFuture createToStream(String stream, String group, CreatePersistentSubscriptionToStreamOptions options) {
        if (options == null) {
            options = CreatePersistentSubscriptionToStreamOptions.get();
        }
        return new CreatePersistentSubscriptionToStream(this.getGrpcClient(), stream, group, options).execute();
    }

    public CompletableFuture createToAll(String group, CreatePersistentSubscriptionToAllOptions options) {
        if (options == null) {
            options = CreatePersistentSubscriptionToAllOptions.get();
        }
        return new CreatePersistentSubscriptionToAll(this.getGrpcClient(), group, options).execute();
    }

    public CompletableFuture updateToStream(String stream, String group) {
        return this.updateToStream(stream, group, UpdatePersistentSubscriptionToStreamOptions.get());
    }

    public CompletableFuture updateToAll(String group) {
        return this.updateToAll(group, UpdatePersistentSubscriptionToAllOptions.get());
    }

    public CompletableFuture updateToStream(String stream, String group, UpdatePersistentSubscriptionToStreamOptions options) {
        if (options == null) {
            options = UpdatePersistentSubscriptionToStreamOptions.get();
        }
        return new UpdatePersistentSubscriptionToStream(this.getGrpcClient(), stream, group, options).execute();
    }

    public CompletableFuture updateToAll(String group, UpdatePersistentSubscriptionToAllOptions options) {
        if (options == null) {
            options = UpdatePersistentSubscriptionToAllOptions.get();
        }
        return new UpdatePersistentSubscriptionToAll(this.getGrpcClient(), group, options).execute();
    }

    public CompletableFuture deleteToStream(String stream, String group) {
        return this.deleteToStream(stream, group, DeletePersistentSubscriptionOptions.get());
    }

    public CompletableFuture deleteToAll(String group) {
        return this.deleteToAll(group, DeletePersistentSubscriptionOptions.get());
    }

    public CompletableFuture deleteToStream(String stream, String group, DeletePersistentSubscriptionOptions options) {
        if (options == null) {
            options = DeletePersistentSubscriptionOptions.get();
        }
        return new DeletePersistentSubscriptionToStream(this.getGrpcClient(), stream, group, options).execute();
    }

    public CompletableFuture deleteToAll(String group, DeletePersistentSubscriptionOptions options) {
        if (options == null) {
            options = DeletePersistentSubscriptionOptions.get();
        }
        return new DeletePersistentSubscriptionToAll(this.getGrpcClient(), group, options).execute();
    }

    public CompletableFuture<PersistentSubscription> subscribeToStream(String stream, String group, PersistentSubscriptionListener listener) {
        return this.subscribeToStream(stream, group, SubscribePersistentSubscriptionOptions.get(), listener);
    }

    public CompletableFuture<PersistentSubscription> subscribeToAll(String group, PersistentSubscriptionListener listener) {
        return this.subscribeToAll(group, SubscribePersistentSubscriptionOptions.get(), listener);
    }

    public CompletableFuture<PersistentSubscription> subscribeToStream(String stream, String group, SubscribePersistentSubscriptionOptions options, PersistentSubscriptionListener listener) {
        if (options == null) {
            options = SubscribePersistentSubscriptionOptions.get();
        }
        return new SubscribePersistentSubscriptionToStream(this.getGrpcClient(), stream, group, options, listener).execute();
    }

    public CompletableFuture<PersistentSubscription> subscribeToAll(String group, SubscribePersistentSubscriptionOptions options, PersistentSubscriptionListener listener) {
        if (options == null) {
            options = SubscribePersistentSubscriptionOptions.get();
        }
        return new SubscribePersistentSubscriptionToAll(this.getGrpcClient(), group, options, listener).execute();
    }

    public CompletableFuture<List<PersistentSubscriptionInfo>> listAll(ListPersistentSubscriptionsOptions options) {
        return ListPersistentSubscriptions.execute(this.getGrpcClient(), options, "", Function.identity());
    }

    public CompletableFuture<List<PersistentSubscriptionInfo>> listAll() {
        return this.listAll(ListPersistentSubscriptionsOptions.get());
    }

    public CompletableFuture<List<PersistentSubscriptionToStreamInfo>> listToStream(String stream, ListPersistentSubscriptionsOptions options) {
        return ListPersistentSubscriptions.execute(this.getGrpcClient(), options, stream, info -> (PersistentSubscriptionToStreamInfo)info);
    }

    public CompletableFuture<List<PersistentSubscriptionToStreamInfo>> listToStream(String stream) {
        return this.listToStream(stream, ListPersistentSubscriptionsOptions.get());
    }

    public CompletableFuture<List<PersistentSubscriptionToAllInfo>> listToAll() {
        return this.listToAll(ListPersistentSubscriptionsOptions.get());
    }

    public CompletableFuture<List<PersistentSubscriptionToAllInfo>> listToAll(ListPersistentSubscriptionsOptions options) {
        return ListPersistentSubscriptions.execute(this.getGrpcClient(), options, "$all", info -> (PersistentSubscriptionToAllInfo)info);
    }

    public CompletableFuture<Optional<PersistentSubscriptionToStreamInfo>> getInfoToStream(String stream, String groupName, GetPersistentSubscriptionInfoOptions options) {
        return GetPersistentSubscriptionInfo.execute(this.getGrpcClient(), options, stream, groupName).thenApply(res -> res.map(PersistentSubscriptionToStreamInfo.class::cast));
    }

    public CompletableFuture<Optional<PersistentSubscriptionToStreamInfo>> getInfoToStream(String stream, String groupName) {
        return this.getInfoToStream(stream, groupName, GetPersistentSubscriptionInfoOptions.get());
    }

    public CompletableFuture<Optional<PersistentSubscriptionToAllInfo>> getInfoToAll(String groupName, GetPersistentSubscriptionInfoOptions options) {
        return GetPersistentSubscriptionInfo.execute(this.getGrpcClient(), options, "$all", groupName).thenApply(res -> res.map(PersistentSubscriptionToAllInfo.class::cast));
    }

    public CompletableFuture<Optional<PersistentSubscriptionToAllInfo>> getInfoToAll(String groupName) {
        return this.getInfoToAll(groupName, GetPersistentSubscriptionInfoOptions.get());
    }

    public CompletableFuture replayParkedMessagesToStream(String stream, String groupName, ReplayParkedMessagesOptions options) {
        return ReplayParkedMessages.execute(this.getGrpcClient(), options, stream, groupName);
    }

    public CompletableFuture replayParkedMessagesToStream(String stream, String groupName) {
        return this.replayParkedMessagesToStream(stream, groupName, ReplayParkedMessagesOptions.get());
    }

    public CompletableFuture replayParkedMessagesToAll(String groupName, ReplayParkedMessagesOptions options) {
        return this.replayParkedMessagesToStream("$all", groupName, options);
    }

    public CompletableFuture replayParkedMessagesToAll(String groupName) throws ExecutionException, InterruptedException {
        return this.replayParkedMessagesToAll(groupName, ReplayParkedMessagesOptions.get());
    }

    public CompletableFuture restartSubsystem() {
        return this.restartSubsystem(RestartPersistentSubscriptionSubsystemOptions.get());
    }

    public CompletableFuture restartSubsystem(RestartPersistentSubscriptionSubsystemOptions options) {
        return RestartPersistentSubscriptionSubsystem.execute(this.getGrpcClient(), options);
    }
}

