/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.Acl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;

public class StreamAcl
implements Acl {
    private ArrayList<String> readRoles;
    private ArrayList<String> writeRoles;
    private ArrayList<String> deleteRoles;
    private ArrayList<String> metaReadRoles;
    private ArrayList<String> metaWriteRoles;

    public StreamAcl addReadRoles(String ... roles) {
        this.readRoles = this.readRoles == null ? new ArrayList<String>() : this.readRoles;
        this.readRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public StreamAcl addWriteRoles(String ... roles) {
        this.writeRoles = this.writeRoles == null ? new ArrayList<String>() : this.writeRoles;
        this.writeRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public StreamAcl addDeleteRoles(String ... roles) {
        this.deleteRoles = this.deleteRoles == null ? new ArrayList<String>() : this.deleteRoles;
        this.deleteRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public StreamAcl addMetaReadRoles(String ... roles) {
        this.metaReadRoles = this.metaReadRoles == null ? new ArrayList<String>() : this.metaReadRoles;
        this.metaReadRoles.addAll(Arrays.asList(roles));
        return this;
    }

    public StreamAcl addMetaWriteRoles(String ... roles) {
        this.metaWriteRoles = this.metaWriteRoles == null ? new ArrayList<String>() : this.metaWriteRoles;
        this.metaWriteRoles.addAll(Arrays.asList(roles));
        return this;
    }

    private static void serializeRoles(HashMap<String, Object> output, String key, ArrayList<String> target) {
        if (target == null) {
            return;
        }
        if (target.size() == 1) {
            output.put(key, target.get(0));
        } else {
            output.put(key, target);
        }
    }

    private static ArrayList<String> deserializeRoles(HashMap<String, Object> source, String key) {
        ArrayList<String> list = null;
        Object value = source.get(key);
        if (value != null) {
            list = new ArrayList<String>();
            if (value instanceof String) {
                list.add((String)value);
            } else if (value instanceof ArrayList) {
                list.addAll((ArrayList)value);
            } else {
                throw new RuntimeException("Unsupported role type: " + value.getClass());
            }
        }
        return list;
    }

    @Override
    public Object serialize() {
        HashMap<String, Object> output = new HashMap<String, Object>();
        StreamAcl.serializeRoles(output, "$r", this.readRoles);
        StreamAcl.serializeRoles(output, "$w", this.writeRoles);
        StreamAcl.serializeRoles(output, "$d", this.deleteRoles);
        StreamAcl.serializeRoles(output, "$mr", this.metaReadRoles);
        StreamAcl.serializeRoles(output, "$mw", this.metaWriteRoles);
        return output;
    }

    static StreamAcl deserialize(HashMap<String, Object> source) {
        StreamAcl acl = new StreamAcl();
        acl.readRoles = StreamAcl.deserializeRoles(source, "$r");
        acl.writeRoles = StreamAcl.deserializeRoles(source, "$w");
        acl.deleteRoles = StreamAcl.deserializeRoles(source, "$d");
        acl.metaReadRoles = StreamAcl.deserializeRoles(source, "$mr");
        acl.metaWriteRoles = StreamAcl.deserializeRoles(source, "$mw");
        return acl;
    }

    public ArrayList<String> getReadRoles() {
        return this.readRoles;
    }

    public ArrayList<String> getWriteRoles() {
        return this.writeRoles;
    }

    public ArrayList<String> getDeleteRoles() {
        return this.deleteRoles;
    }

    public ArrayList<String> getMetaReadRoles() {
        return this.metaReadRoles;
    }

    public ArrayList<String> getMetaWriteRoles() {
        return this.metaWriteRoles;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamAcl streamAcl = (StreamAcl)o;
        return Objects.equals(this.readRoles, streamAcl.readRoles) && Objects.equals(this.writeRoles, streamAcl.writeRoles) && Objects.equals(this.deleteRoles, streamAcl.deleteRoles) && Objects.equals(this.metaReadRoles, streamAcl.metaReadRoles) && Objects.equals(this.metaWriteRoles, streamAcl.metaWriteRoles);
    }

    public int hashCode() {
        return Objects.hash(this.readRoles, this.writeRoles, this.deleteRoles, this.metaReadRoles, this.metaWriteRoles);
    }

    public String toString() {
        return "StreamAcl{readRoles=" + this.readRoles + ", writeRoles=" + this.writeRoles + ", deleteRoles=" + this.deleteRoles + ", metaReadRoles=" + this.metaReadRoles + ", metaWriteRoles=" + this.metaWriteRoles + '}';
    }
}

