/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ClusterDiscovery;
import com.eventstore.dbclient.ConnectionService;
import com.eventstore.dbclient.Discovery;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.GrpcClient;
import com.eventstore.dbclient.ServerVersion;
import com.eventstore.dbclient.SingleNodeDiscovery;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStoreDBClientBase {
    final Logger logger = LoggerFactory.getLogger(EventStoreDBClientBase.class);
    private final GrpcClient client;

    EventStoreDBClientBase(EventStoreDBClientSettings settings) {
        Discovery discovery = settings.getHosts().length == 1 && !settings.isDnsDiscover() ? new SingleNodeDiscovery(settings.getHosts()[0]) : new ClusterDiscovery(settings);
        ConnectionService service = new ConnectionService(settings, discovery);
        this.client = service.getHandle();
        CompletableFuture.runAsync(service, this.createConnectionLoopExecutor());
    }

    private Executor createConnectionLoopExecutor() {
        return Executors.newSingleThreadExecutor(r -> {
            Thread thread = new Thread(r, "esdb-client-" + UUID.randomUUID());
            thread.setDaemon(true);
            return thread;
        });
    }

    public CompletableFuture<Void> shutdown() {
        return this.client.shutdown();
    }

    public boolean isShutdown() {
        return this.client.isShutdown();
    }

    public CompletableFuture<Optional<ServerVersion>> getServerVersion() {
        return this.client.getServerVersion();
    }

    GrpcClient getGrpcClient() {
        return this.client;
    }
}

