/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ConnectionShutdownException;
import com.eventstore.dbclient.CreateChannel;
import com.eventstore.dbclient.EventStoreDBClientSettings;
import com.eventstore.dbclient.Msg;
import com.eventstore.dbclient.NotLeaderException;
import com.eventstore.dbclient.RunWorkItem;
import com.eventstore.dbclient.ServerVersion;
import com.eventstore.dbclient.Shutdown;
import com.eventstore.dbclient.WorkItemArgs;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GrpcClient {
    private static final Logger logger = LoggerFactory.getLogger(GrpcClient.class);
    private final AtomicBoolean closed;
    private final LinkedBlockingQueue<Msg> queue;
    private final EventStoreDBClientSettings settings;

    GrpcClient(EventStoreDBClientSettings settings, AtomicBoolean closed, LinkedBlockingQueue<Msg> queue) {
        this.settings = settings;
        this.closed = closed;
        this.queue = queue;
    }

    public boolean isShutdown() {
        return this.closed.get();
    }

    private CompletableFuture<Void> push(Msg msg) {
        return CompletableFuture.runAsync(() -> {
            try {
                if (this.closed.get()) {
                    if (msg instanceof RunWorkItem) {
                        RunWorkItem args = (RunWorkItem)msg;
                        args.reportError(new ConnectionShutdownException());
                    }
                    if (msg instanceof Shutdown) {
                        ((Shutdown)msg).complete();
                    }
                    return;
                }
                this.queue.put(msg);
                logger.debug("Scheduled msg: {}", (Object)msg);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public CompletableFuture<Optional<ServerVersion>> getServerVersion() {
        return this.runWithArgs(args -> CompletableFuture.completedFuture(args.getServerVersion()));
    }

    public <A> CompletableFuture<A> run(Function<ManagedChannel, CompletableFuture<A>> action) {
        return this.runWithArgs(args -> (CompletableFuture)action.apply(args.getChannel()));
    }

    public <A> CompletableFuture<A> runWithArgs(Function<WorkItemArgs, CompletableFuture<A>> action) {
        CompletableFuture result = new CompletableFuture();
        String msgId = UUID.randomUUID().toString();
        LinkedBlockingQueue<Msg> queue = this.queue;
        return this.push(new RunWorkItem(msgId, (args, fatalError) -> {
            if (fatalError != null) {
                result.completeExceptionally(fatalError);
                return;
            }
            ((CompletableFuture)action.apply(args)).whenComplete((outcome, error) -> {
                if (outcome != null) {
                    result.complete(outcome);
                    return;
                }
                try {
                    StatusRuntimeException ex;
                    if (error instanceof NotLeaderException) {
                        NotLeaderException ex2 = (NotLeaderException)error;
                        result.completeExceptionally(ex2);
                        queue.put(new CreateChannel(args.getId(), ex2.getLeaderEndpoint()));
                        return;
                    }
                    if (error instanceof StatusRuntimeException && (ex = (StatusRuntimeException)error).getStatus().getCode().equals((Object)Status.Code.UNAVAILABLE)) {
                        queue.put(new CreateChannel(args.getId()));
                    }
                    logger.debug("RunWorkItem[{}] completed exceptionally: {}", (Object)msgId, (Object)error.toString());
                    result.completeExceptionally((Throwable)error);
                }
                catch (InterruptedException e) {
                    result.completeExceptionally(e);
                }
            });
        })).thenComposeAsync(x -> result);
    }

    public CompletableFuture<Void> shutdown() {
        CompletableFuture completion = new CompletableFuture();
        return this.push(new Shutdown(completion::complete)).thenComposeAsync(x -> completion);
    }

    public EventStoreDBClientSettings getSettings() {
        return this.settings;
    }
}

