/*
 * Decompiled with CFR 0.152.
 */
package com.eventstore.dbclient;

import com.eventstore.dbclient.ReadMessage;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.ClientCallStreamObserver;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

class ReadSubscription
implements Subscription {
    private final Subscriber<? super ReadMessage> subscriber;
    private ClientCallStreamObserver<?> streamObserver;
    private final AtomicLong requested = new AtomicLong(0L);
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final Lock lock = new ReentrantLock();
    private final Condition hasRequested = this.lock.newCondition();

    ReadSubscription(Subscriber<? super ReadMessage> subscriber) {
        this.subscriber = subscriber;
    }

    public void setStreamObserver(ClientCallStreamObserver<?> streamObserver) {
        this.streamObserver = streamObserver;
    }

    public void onError(Throwable error) {
        StatusRuntimeException statusRuntimeException;
        if (error instanceof StatusRuntimeException && (statusRuntimeException = (StatusRuntimeException)error).getStatus().getCode() == Status.Code.CANCELLED) {
            return;
        }
        if (!this.terminated.get()) {
            this.subscriber.onError(error);
        }
        this.cancel();
    }

    public void onNext(ReadMessage message) {
        this.lock.lock();
        while (this.requested.get() == 0L && !this.terminated.get()) {
            this.hasRequested.awaitUninterruptibly();
        }
        if (!this.terminated.get()) {
            this.subscriber.onNext((Object)message);
            this.requested.decrementAndGet();
        }
        this.lock.unlock();
    }

    public void onCompleted() {
        if (this.terminated.compareAndSet(false, true)) {
            this.subscriber.onComplete();
        }
    }

    public void request(long n) {
        if (n <= 0L) {
            this.subscriber.onError((Throwable)new IllegalArgumentException("non-positive subscription request: " + n));
        }
        this.lock.lock();
        this.requested.updateAndGet(current -> current + n);
        this.hasRequested.signal();
        this.lock.unlock();
    }

    public void cancel() {
        if (this.terminated.compareAndSet(false, true) && this.streamObserver != null) {
            this.streamObserver.cancel("Stream has been cancelled manually.", null);
        }
    }
}

